/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.AuthenticationFlowResolver;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.services.ErrorPageException;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.UserSessionCrossDCManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public abstract class AuthorizationEndpointBase {
    private static final Logger logger = Logger.getLogger(AuthorizationEndpointBase.class);
    public static final String APP_INITIATED_FLOW = "APP_INITIATED_FLOW";
    protected RealmModel realm;
    protected EventBuilder event;
    protected AuthenticationManager authManager;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected HttpRequest httpRequest;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;

    public AuthorizationEndpointBase(RealmModel realm, EventBuilder event) {
        this.realm = realm;
        this.event = event;
    }

    protected AuthenticationProcessor createProcessor(AuthenticationSessionModel authSession, String flowId, String flowPath) {
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setAuthenticationSession(authSession).setFlowPath(flowPath).setFlowId(flowId).setBrowserFlow(true).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realm).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.httpRequest);
        authSession.setAuthNote("current.flow.path", flowPath);
        return processor;
    }

    protected Response handleBrowserAuthenticationRequest(AuthenticationSessionModel authSession, LoginProtocol protocol, boolean isPassive, boolean redirectToAuthentication) {
        AuthenticationFlowModel flow = this.getAuthenticationFlow(authSession);
        String flowId = flow.getId();
        AuthenticationProcessor processor = this.createProcessor(authSession, flowId, "authenticate");
        this.event.detail("code_id", authSession.getParentSession().getId());
        if (isPassive) {
            try {
                if (processor.authenticateOnly() != null) {
                    Response response = protocol.sendError(authSession, LoginProtocol.Error.PASSIVE_LOGIN_REQUIRED);
                    return response;
                }
                AuthenticationManager.setRolesAndMappersInSession(authSession);
                if (processor.nextRequiredAction() != null) {
                    Response response = protocol.sendError(authSession, LoginProtocol.Error.PASSIVE_INTERACTION_REQUIRED);
                    return response;
                }
                processor.attachSession();
            }
            catch (Exception e) {
                return processor.handleBrowserException(e);
            }
            return processor.finishAuthentication(protocol);
        }
        try {
            RestartLoginCookie.setRestartCookie(this.session, this.realm, this.clientConnection, this.uriInfo, authSession);
            if (redirectToAuthentication) {
                return processor.redirectToFlow();
            }
            return processor.authenticate();
        }
        catch (Exception e) {
            return processor.handleBrowserException(e);
        }
    }

    protected AuthenticationFlowModel getAuthenticationFlow(AuthenticationSessionModel authSession) {
        return AuthenticationFlowResolver.resolveBrowserFlow((AuthenticationSessionModel)authSession);
    }

    protected void checkSsl() {
        if (!this.uriInfo.getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            this.event.error("ssl_required");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "httpsRequiredMessage", new Object[0]);
        }
    }

    protected void checkRealm() {
        if (!this.realm.isEnabled()) {
            this.event.error("realm_disabled");
            throw new ErrorPageException(this.session, Response.Status.BAD_REQUEST, "realmNotEnabledMessage", new Object[0]);
        }
    }

    protected AuthenticationSessionModel createAuthenticationSession(ClientModel client, String requestState) {
        AuthenticationSessionModel authSession;
        RootAuthenticationSessionModel rootAuthSession;
        AuthenticationSessionManager manager = new AuthenticationSessionManager(this.session);
        String authSessionId = manager.getCurrentAuthenticationSessionId(this.realm);
        RootAuthenticationSessionModel rootAuthenticationSessionModel = rootAuthSession = authSessionId == null ? null : this.session.authenticationSessions().getRootAuthenticationSession(this.realm, authSessionId);
        if (rootAuthSession != null) {
            authSession = rootAuthSession.createAuthenticationSession(client);
            logger.debugf("Sent request to authz endpoint. Root authentication session with ID '%s' exists. Client is '%s' . Created new authentication session with tab ID: %s", (Object)rootAuthSession.getId(), (Object)client.getClientId(), (Object)authSession.getTabId());
        } else {
            UserSessionModel userSession;
            UserSessionModel userSessionModel = userSession = authSessionId == null ? null : new UserSessionCrossDCManager(this.session).getUserSessionIfExistsRemotely(this.realm, authSessionId);
            if (userSession != null) {
                rootAuthSession = this.session.authenticationSessions().createRootAuthenticationSession(authSessionId, this.realm);
                authSession = rootAuthSession.createAuthenticationSession(client);
                logger.debugf("Sent request to authz endpoint. We don't have root authentication session with ID '%s' but we have userSession.Re-created root authentication session with same ID. Client is: %s . New authentication session tab ID: %s", (Object)authSessionId, (Object)client.getClientId(), (Object)authSession.getTabId());
            } else {
                rootAuthSession = manager.createAuthenticationSession(this.realm, true);
                authSession = rootAuthSession.createAuthenticationSession(client);
                logger.debugf("Sent request to authz endpoint. Created new root authentication session with ID '%s' . Client: %s . New authentication session tab ID: %s", (Object)rootAuthSession.getId(), (Object)client.getClientId(), (Object)authSession.getTabId());
            }
        }
        ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setAuthenticationSession(authSession);
        return authSession;
    }
}

