/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.ConsoleDisplayMode;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.OTPCredentialProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.freemarker.model.TotpBean;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.credential.OTPCredentialModel;
import org.keycloak.models.utils.CredentialValidation;
import org.keycloak.services.validation.Validation;

public class ConsoleUpdateTotp
implements RequiredActionProvider {
    public static final ConsoleUpdateTotp SINGLETON = new ConsoleUpdateTotp();

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        TotpBean totpBean = new TotpBean(context.getSession(), context.getRealm(), context.getUser(), context.getUriInfo().getRequestUriBuilder());
        String totpSecret = totpBean.getTotpSecret();
        context.getAuthenticationSession().setAuthNote("totpSecret", totpSecret);
        Response challenge = this.challenge(context).form().setAttribute("totp", (Object)totpBean).createForm("login-config-totp-text.ftl");
        context.challenge(challenge);
    }

    protected ConsoleDisplayMode challenge(RequiredActionContext context) {
        return ConsoleDisplayMode.challenge((RequiredActionContext)context).header().param("totp").label("console-otp").challenge();
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        event.event(EventType.UPDATE_TOTP);
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String challengeResponse = (String)formData.getFirst((Object)"totp");
        String totpSecret = context.getAuthenticationSession().getAuthNote("totpSecret");
        String userLabel = (String)formData.getFirst((Object)"userLabel");
        OTPPolicy policy = context.getRealm().getOTPPolicy();
        OTPCredentialModel credentialModel = OTPCredentialModel.createFromPolicy((RealmModel)context.getRealm(), (String)totpSecret, (String)userLabel);
        if (Validation.isBlank(challengeResponse)) {
            context.challenge(this.challenge(context).message("missingTotpMessage", new String[0]));
            return;
        }
        if (!CredentialValidation.validOTP((String)challengeResponse, (OTPCredentialModel)credentialModel, (int)policy.getLookAheadWindow())) {
            context.challenge(this.challenge(context).message("invalidTotpMessage", new String[0]));
            return;
        }
        OTPCredentialProvider otpCredentialProvider = (OTPCredentialProvider)context.getSession().getProvider(CredentialProvider.class, "keycloak-otp");
        CredentialModel createdCredential = otpCredentialProvider.createCredential(context.getRealm(), context.getUser(), credentialModel);
        UserCredentialModel credential = new UserCredentialModel(createdCredential.getId(), otpCredentialProvider.getType(), challengeResponse);
        if (!otpCredentialProvider.isValid(context.getRealm(), context.getUser(), (CredentialInput)credential)) {
            context.challenge(this.challenge(context).message("invalidTotpMessage", new String[0]));
            return;
        }
        context.getAuthenticationSession().removeAuthNote("totpSecret");
        context.success();
    }

    public void close() {
    }
}

