/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.PasswordCredentialProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.PasswordCredentialModel;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.Auth;

public class AccountCredentialResource {
    private final KeycloakSession session;
    private final EventBuilder event;
    private final UserModel user;
    private final RealmModel realm;
    private Auth auth;

    public AccountCredentialResource(KeycloakSession session, EventBuilder event, UserModel user, Auth auth) {
        this.session = session;
        this.event = event;
        this.user = user;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
    }

    @GET
    @Path(value="password")
    @Produces(value={"application/json"})
    public PasswordDetails passwordDetails() throws IOException {
        this.auth.requireOneOf("manage-account", "view-profile");
        PasswordCredentialProvider passwordProvider = (PasswordCredentialProvider)this.session.getProvider(CredentialProvider.class, "keycloak-password");
        PasswordCredentialModel password = passwordProvider.getPassword(this.realm, this.user);
        PasswordDetails details = new PasswordDetails();
        if (password != null) {
            details.setRegistered(true);
            details.setLastUpdate(password.getCreatedDate());
        } else {
            details.setRegistered(false);
        }
        return details;
    }

    @POST
    @Path(value="password")
    @Consumes(value={"application/json"})
    public Response passwordUpdate(PasswordUpdate update) {
        this.auth.require("manage-account");
        this.event.event(EventType.UPDATE_PASSWORD);
        UserCredentialModel cred = UserCredentialModel.password((String)update.getCurrentPassword());
        if (!this.session.userCredentialManager().isValid(this.realm, this.user, new CredentialInput[]{cred})) {
            this.event.error("invalid_user_credentials");
            return ErrorResponse.error("invalidPasswordExistingMessage", Response.Status.BAD_REQUEST);
        }
        if (update.getNewPassword() == null) {
            return ErrorResponse.error("invalidPasswordExistingMessage", Response.Status.BAD_REQUEST);
        }
        String confirmation = update.getConfirmation();
        if (confirmation != null && !update.getNewPassword().equals(confirmation)) {
            return ErrorResponse.error("notMatchPasswordMessage", Response.Status.BAD_REQUEST);
        }
        try {
            this.session.userCredentialManager().updateCredential(this.realm, this.user, (CredentialInput)UserCredentialModel.password((String)update.getNewPassword(), (boolean)false));
        }
        catch (ModelException e) {
            return ErrorResponse.error(e.getMessage(), e.getParameters(), Response.Status.BAD_REQUEST);
        }
        return Response.ok().build();
    }

    public static class PasswordUpdate {
        private String currentPassword;
        private String newPassword;
        private String confirmation;

        public String getCurrentPassword() {
            return this.currentPassword;
        }

        public void setCurrentPassword(String currentPassword) {
            this.currentPassword = currentPassword;
        }

        public String getNewPassword() {
            return this.newPassword;
        }

        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }

        public String getConfirmation() {
            return this.confirmation;
        }

        public void setConfirmation(String confirmation) {
            this.confirmation = confirmation;
        }
    }

    public static class PasswordDetails {
        private boolean registered;
        private long lastUpdate;

        public boolean isRegistered() {
            return this.registered;
        }

        public void setRegistered(boolean registered) {
            this.registered = registered;
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }
    }
}

