/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.api.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TransformationDictionary;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.utils.SourceUtils;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.compiler.api.dto.CommonCompilationDTO;
import org.kie.pmml.compiler.api.dto.CompilationDTO;

public abstract class AbstractSpecificCompilationDTO<T extends Model>
implements CompilationDTO<T> {
    private static final long serialVersionUID = -3691191496300060907L;
    private final CompilationDTO<T> source;
    private final List<Field<?>> fields;

    protected AbstractSpecificCompilationDTO(PMML pmml, T model, HasClassLoader hasClassloader, String packageName, List<Field<?>> fields) {
        this(CommonCompilationDTO.fromPackageNameAndFields(pmml, model, hasClassloader, packageName, fields));
    }

    protected AbstractSpecificCompilationDTO(CompilationDTO<T> source) {
        this.source = source;
        this.fields = new ArrayList(source.getFields());
    }

    @Override
    public PMML getPmml() {
        return this.source.getPmml();
    }

    @Override
    public TransformationDictionary getTransformationDictionary() {
        return this.source.getTransformationDictionary();
    }

    @Override
    public T getModel() {
        return this.source.getModel();
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.source.getMiningSchema();
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.source.getMiningFunction();
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.source.getLocalTransformations();
    }

    @Override
    public Output getOutput() {
        return this.source.getOutput();
    }

    @Override
    public Targets getTargets() {
        return this.source.getTargets();
    }

    @Override
    public List<Field<?>> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public DataField getTargetDataField() {
        return this.source.getTargetDataField();
    }

    @Override
    public OpType getOpType() {
        return this.source.getOpType();
    }

    @Override
    public String getModelName() {
        return this.source.getModelName();
    }

    @Override
    public String getTargetFieldName() {
        return this.source.getTargetFieldName();
    }

    @Override
    public String getPackageName() {
        return this.source.getPackageName();
    }

    @Override
    public String getSimpleClassName() {
        return this.source.getSimpleClassName();
    }

    @Override
    public String getPackageCanonicalClassName() {
        return this.source.getPackageCanonicalClassName();
    }

    @Override
    public Class<?> compileAndLoadClass(Map<String, String> sourcesMap) {
        try {
            SourceUtils.dumpSources(sourcesMap, (PMML_MODEL)this.source.getPMML_MODEL());
            return this.source.compileAndLoadClass(sourcesMap);
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    @Override
    public HasClassLoader getHasClassloader() {
        return this.source.getHasClassloader();
    }

    @Override
    public PMML_MODEL getPMML_MODEL() {
        return this.source.getPMML_MODEL();
    }

    @Override
    public MINING_FUNCTION getMINING_FUNCTION() {
        return this.source.getMINING_FUNCTION();
    }

    public void addFields(List<Field<?>> toAdd) {
        if (toAdd != null) {
            toAdd.forEach(field -> {
                this.fields.removeIf(e -> e.getClass().equals(field.getClass()) && e.getName().equals((Object)field.getName()));
                this.fields.add((Field<?>)field);
            });
        }
    }

    protected CompilationDTO<T> getSource() {
        return this.source;
    }
}

