/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.TestTimedOutException;

public class TestStatusListener
extends RunListener {
    private final BufferedWriter writer;

    public TestStatusListener() {
        try {
            this.writer = Files.newBufferedWriter(Paths.get("./target/testStatusListener." + ManagementFactory.getRuntimeMXBean().getName().replaceAll("\\W+", "") + "." + System.nanoTime() + ".log", new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("TestStatusListener unable to open writer for logging to file test status updates.", e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    private synchronized void write(String method, Description description) throws IOException {
        this.writer.write(method);
        this.writer.write("\t");
        this.writer.write(description.getClassName());
        this.writer.write(".");
        if (description.getMethodName() != null) {
            this.writer.write(description.getMethodName());
        }
        this.writer.newLine();
        this.writer.flush();
    }

    private synchronized void write(String method, Failure failure) throws IOException {
        this.writer.write(method);
        this.writer.write("\t");
        if (failure.getMessage() != null) {
            this.writer.write(failure.getMessage());
        }
        this.writer.newLine();
        this.writer.flush();
    }

    private synchronized void write(String method, Result result) throws IOException {
        this.writer.write(method);
        this.writer.write("\t");
        this.writer.write(result.toString());
        this.writer.newLine();
        this.writer.flush();
    }

    private synchronized void writeThreadDump() throws IOException {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo ti : threadMxBean.dumpAllThreads(true, true)) {
            this.writer.write(ti.toString());
            if (ti.getStackTrace().length <= 8) continue;
            this.writer.write("full stacktrace:\n");
            this.writer.write(TestStatusListener.fullStackTrace(ti));
            this.writer.write("\n");
        }
        this.writer.newLine();
        this.writer.flush();
    }

    private static String fullStackTrace(ThreadInfo ti) {
        StringBuilder sb = new StringBuilder();
        Stream.of(ti.getStackTrace()).forEach(ste -> {
            sb.append(" ");
            sb.append(ste.toString());
            sb.append("\n");
            Stream.of(ti.getLockedMonitors()).filter(m -> ste.equals(m.getLockedStackFrame())).forEach(lm -> {
                sb.append("  (locked: ");
                sb.append(lm);
                sb.append(" )\n");
            });
        });
        return sb.toString();
    }

    public void testRunStarted(Description description) throws Exception {
        this.write("testRunStarted", description);
    }

    public void testRunFinished(Result result) throws Exception {
        this.write("testRunFinished", result);
    }

    public void testStarted(Description description) throws Exception {
        this.write("testStarted", description);
    }

    public void testFinished(Description description) throws Exception {
        this.write("testFinished", description);
    }

    public void testFailure(Failure failure) throws Exception {
        if (failure.getException() instanceof TestTimedOutException) {
            this.writeThreadDump();
        }
        this.write("testFailure", failure);
    }

    public void testAssumptionFailure(Failure failure) {
        try {
            this.write("testAssumptionFailure", failure);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testIgnored(Description description) throws Exception {
        this.write("testIgnored", description);
    }
}

