/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.event;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashSet;
import org.kie.kogito.index.event.AbstractBuilder;
import org.kie.kogito.index.event.KogitoCloudEvent;
import org.kie.kogito.index.model.ProcessInstance;

public class KogitoProcessCloudEvent
extends KogitoCloudEvent<ProcessInstance> {
    @JsonProperty(value="kogitoProcessinstanceState")
    private Integer state;
    @JsonProperty(value="kogitoParentProcessinstanceId")
    private String parentProcessInstanceId;

    public static Builder builder() {
        return new Builder();
    }

    public String getParentProcessInstanceId() {
        return this.parentProcessInstanceId;
    }

    public void setParentProcessInstanceId(String id) {
        if (id != null && !id.trim().isEmpty()) {
            this.parentProcessInstanceId = id;
        }
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    @Override
    public void setSource(URI source) {
        super.setSource(source);
        if (this.getData() != null && source != null) {
            ((ProcessInstance)this.getData()).setEndpoint(source.toString());
        }
    }

    @Override
    public void setKogitoAddons(String kogitoAddons) {
        super.setKogitoAddons(kogitoAddons);
        if (this.getData() != null && kogitoAddons != null) {
            ((ProcessInstance)this.getData()).setAddons(new HashSet<String>(Arrays.asList(kogitoAddons.split(","))));
        }
    }

    @Override
    public void setTime(ZonedDateTime time) {
        super.setTime(time);
        if (this.getData() != null && time != null) {
            ((ProcessInstance)this.getData()).setLastUpdate(time);
        }
    }

    @Override
    public void setData(ProcessInstance data) {
        super.setData(data);
        this.setTime(this.getTime());
        this.setKogitoAddons(this.getKogitoAddons());
        this.setSource(this.getSource());
    }

    @Override
    public String toString() {
        return "KogitoProcessCloudEvent{state=" + this.state + ", parentProcessInstanceId='" + this.parentProcessInstanceId + "'} " + super.toString();
    }

    public static final class Builder
    extends AbstractBuilder<Builder, ProcessInstance, KogitoProcessCloudEvent> {
        private Builder() {
            super(new KogitoProcessCloudEvent());
        }

        public Builder state(Integer state) {
            ((KogitoProcessCloudEvent)this.event).setState(state);
            return this;
        }

        public Builder parentProcessInstanceId(String parentProcessInstanceId) {
            ((KogitoProcessCloudEvent)this.event).setParentProcessInstanceId(parentProcessInstanceId);
            return this;
        }

        public Builder kogitoReferenceId(String kogitoReferenceId) {
            ((KogitoProcessCloudEvent)this.event).setKogitoReferenceId(kogitoReferenceId);
            return this;
        }

        public Builder kogitoAddons(String kogitoAddons) {
            ((KogitoProcessCloudEvent)this.event).setKogitoAddons(kogitoAddons);
            return this;
        }
    }
}

