/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.pmml.openapi.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.kogito.pmml.openapi.PMMLOASUtils;
import org.kie.kogito.pmml.openapi.api.PMMLOASResult;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.api.enums.ResultCode;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.api.models.OutputField;

public class PMMLOASResultImpl
implements PMMLOASResult {
    protected final ObjectNode jsonNodes = JsonUtil.objectNode();

    private PMMLOASResultImpl() {
        ObjectNode definitions = JsonUtil.objectNode();
        this.jsonNodes.set("definitions", (JsonNode)definitions);
        this.addOutputSet();
    }

    @Override
    public ObjectNode jsonSchemaNode() {
        return this.jsonNodes;
    }

    protected void addOutputSet() {
        ObjectNode definitions = (ObjectNode)this.jsonNodes.get("definitions");
        ObjectNode outputSet = PMMLOASUtils.createSetNodeInParent(definitions, "OutputSet");
        PMMLOASUtils.addToSetNode("correlationId", DATA_TYPE.STRING, Collections.emptyList(), outputSet);
        PMMLOASUtils.addToSetNode("segmentationId", DATA_TYPE.STRING, Collections.emptyList(), outputSet);
        PMMLOASUtils.addToSetNode("segmentId", DATA_TYPE.STRING, Collections.emptyList(), outputSet);
        PMMLOASUtils.addToSetNode("segmentIndex", DATA_TYPE.INTEGER, Collections.emptyList(), outputSet);
        List<String> allowedValues = Arrays.stream(ResultCode.values()).map(ResultCode::getName).collect(Collectors.toList());
        PMMLOASUtils.addToSetNode("resultCode", DATA_TYPE.STRING, allowedValues, outputSet);
        PMMLOASUtils.addToSetNode("resultObjectName", DATA_TYPE.STRING, Collections.emptyList(), outputSet);
    }

    protected void addMiningFields(List<MiningField> toAdd) {
        ObjectNode definitionsNode = (ObjectNode)this.jsonNodes.get("definitions");
        ObjectNode inputSetNode = JsonUtil.objectNode();
        definitionsNode.set("InputSet", (JsonNode)inputSetNode);
        inputSetNode.set("type", (JsonNode)new TextNode("object"));
        ArrayNode requiredNode = JsonUtil.arrayNode();
        inputSetNode.set("required", (JsonNode)requiredNode);
        ObjectNode propertiesNode = JsonUtil.objectNode();
        inputSetNode.set("properties", (JsonNode)propertiesNode);
        toAdd.forEach(miningField -> {
            if (PMMLOASUtils.isRequired(miningField)) {
                requiredNode.add(miningField.getName());
            }
            if (PMMLOASUtils.isPredicted(miningField)) {
                this.addToResultSet(miningField.getName(), miningField.getDataType(), miningField.getAllowedValues());
                this.addToResultVariables(miningField.getName(), miningField.getDataType(), miningField.getAllowedValues());
            } else {
                ObjectNode typeFieldNode = JsonUtil.objectNode();
                String mappedType = PMMLOASUtils.getMappedType(miningField.getDataType());
                typeFieldNode.set("type", (JsonNode)new TextNode(mappedType));
                String mappedFormat = PMMLOASUtils.getMappedFormat(miningField.getDataType());
                if (mappedFormat != null) {
                    typeFieldNode.set("format", (JsonNode)new TextNode(mappedFormat));
                }
                if (miningField.getMissingValueReplacement() != null && !miningField.getMissingValueReplacement().isEmpty()) {
                    typeFieldNode.set("default", (JsonNode)new TextNode(miningField.getMissingValueReplacement()));
                }
                if (miningField.getAllowedValues() != null && !miningField.getAllowedValues().isEmpty()) {
                    ArrayNode availableValues = JsonUtil.arrayNode();
                    miningField.getAllowedValues().forEach(arg_0 -> ((ArrayNode)availableValues).add(arg_0));
                    typeFieldNode.set("enum", (JsonNode)availableValues);
                }
                if (miningField.getIntervals() != null && !miningField.getIntervals().isEmpty()) {
                    PMMLOASUtils.addIntervals(typeFieldNode, miningField.getIntervals());
                }
                propertiesNode.set(miningField.getName(), (JsonNode)typeFieldNode);
            }
        });
    }

    protected void addOutputFields(List<OutputField> toAdd) {
        toAdd.forEach(outputField -> this.addToResultVariables(outputField.getName(), outputField.getDataType(), outputField.getAllowedValues()));
    }

    protected void addToResultSet(String fieldName, DATA_TYPE dataType, List<String> allowedValues) {
        ObjectNode resultSetNode = this.conditionallyCreateResultSetNode();
        PMMLOASUtils.addToSetNode(fieldName, dataType, allowedValues, resultSetNode);
    }

    protected void addToResultVariables(String fieldName, DATA_TYPE dataType, List<String> allowedValues) {
        ObjectNode resultVariablesNode = this.conditionallyCreateResultVariablesNode();
        PMMLOASUtils.addToSetNode(fieldName, dataType, allowedValues, resultVariablesNode);
    }

    protected ObjectNode conditionallyCreateResultSetNode() {
        return this.conditionallyCreateSetNode("ResultSet");
    }

    protected ObjectNode conditionallyCreateResultVariablesNode() {
        ObjectNode definitionsNode = (ObjectNode)this.jsonNodes.get("definitions");
        ObjectNode outputSetNode = (ObjectNode)definitionsNode.get("OutputSet");
        ObjectNode propertiesNode = (ObjectNode)outputSetNode.get("properties");
        if (propertiesNode.get("resultVariables") == null) {
            PMMLOASUtils.createSetNodeInParent(propertiesNode, "resultVariables");
        }
        return (ObjectNode)propertiesNode.get("resultVariables");
    }

    protected ObjectNode conditionallyCreateSetNode(String nodeToCreate) {
        ObjectNode definitionsNode = (ObjectNode)this.jsonNodes.get("definitions");
        if (definitionsNode.get(nodeToCreate) == null) {
            PMMLOASUtils.createSetNodeInParent(definitionsNode, nodeToCreate);
        }
        return (ObjectNode)definitionsNode.get(nodeToCreate);
    }

    public static class Builder {
        private final PMMLOASResultImpl toBuild = new PMMLOASResultImpl();

        public Builder withMiningFields(List<MiningField> miningFields) {
            this.toBuild.addMiningFields(miningFields);
            return this;
        }

        public Builder withOutputFields(List<OutputField> outputFields) {
            this.toBuild.addOutputFields(outputFields);
            return this;
        }

        public PMMLOASResult build() {
            return this.toBuild;
        }
    }
}

