/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.impl;

import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefBuilder;

public abstract class AbstractDataSetDefBuilder<T>
implements DataSetDefBuilder<T> {
    protected DataSetDef def = this.createDataSetDef();

    protected abstract DataSetDef createDataSetDef();

    @Override
    public T uuid(String uuid) {
        this.def.setUUID(uuid);
        return (T)this;
    }

    @Override
    public T name(String name) {
        this.def.setName(name);
        return (T)this;
    }

    @Override
    public T pushOn(int pushMaxSize) {
        return (T)this;
    }

    @Override
    public T pushOff() {
        return (T)this;
    }

    @Override
    public T cacheOn(int maxRowsInCache) {
        this.def.setCacheEnabled(true);
        this.def.setCacheMaxRows(maxRowsInCache);
        return (T)this;
    }

    @Override
    public T cacheOff() {
        this.def.setCacheEnabled(false);
        return (T)this;
    }

    @Override
    public T refreshOn(String refreshTime, boolean refreshAlways) {
        this.def.setRefreshTime(refreshTime);
        this.def.setRefreshAlways(refreshAlways);
        return (T)this;
    }

    @Override
    public T refreshOff() {
        this.def.setRefreshTime(null);
        return (T)this;
    }

    @Override
    public T label(String columnId) {
        this.def.addColumn(columnId, ColumnType.LABEL);
        return (T)this;
    }

    @Override
    public T text(String columnId) {
        this.def.addColumn(columnId, ColumnType.TEXT);
        return (T)this;
    }

    @Override
    public T number(String columnId) {
        this.def.addColumn(columnId, ColumnType.NUMBER);
        return (T)this;
    }

    @Override
    public T date(String columnId) {
        this.def.addColumn(columnId, ColumnType.DATE);
        return (T)this;
    }

    @Override
    public T column(String columnId, ColumnType type) {
        this.def.addColumn(columnId, type);
        return (T)this;
    }

    @Override
    public DataSetDef buildDef() {
        return this.def;
    }
}

