/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.hitbtc.v2.Hitbtc;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcAddress;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcBalance;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcException;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcInternalTransferResponse;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrder;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOwnTrade;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTransaction;
import si.mazi.rescu.HttpStatusIOException;

@Path(value="/api/2/")
public interface HitbtcAuthenticated
extends Hitbtc {
    @GET
    @Path(value="account/balance")
    public List<HitbtcBalance> getMainBalance() throws IOException, HitbtcException;

    @GET
    @Path(value="account/crypto/address/{currency}")
    public HitbtcAddress getHitbtcDepositAddress(@PathParam(value="currency") String var1) throws IOException, HitbtcException;

    @GET
    @Path(value="account/transactions")
    public List<HitbtcTransaction> transactions(@QueryParam(value="currency") String var1, @QueryParam(value="limit") Integer var2, @QueryParam(value="offset") Integer var3) throws HttpStatusIOException;

    @POST
    @Path(value="account/transfer")
    public HitbtcInternalTransferResponse transferToTrading(@FormParam(value="amount") BigDecimal var1, @FormParam(value="currency") String var2, @FormParam(value="type") String var3) throws IOException;

    @POST
    @Path(value="account/crypto/withdraw")
    public Map payout(@FormParam(value="amount") BigDecimal var1, @FormParam(value="currency") String var2, @FormParam(value="address") String var3) throws HttpStatusIOException;

    @GET
    @Path(value="order")
    public List<HitbtcOrder> getHitbtcActiveOrders() throws IOException, HitbtcException;

    @POST
    @Path(value="order")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public HitbtcOrder postHitbtcNewOrder(@FormParam(value="clientOrderId") String var1, @FormParam(value="symbol") String var2, @FormParam(value="side") String var3, @FormParam(value="price") BigDecimal var4, @FormParam(value="quantity") BigDecimal var5, @FormParam(value="type") String var6, @FormParam(value="timeInForce") String var7) throws IOException, HitbtcException;

    @PATCH
    @Path(value="order/{clientOrderId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public HitbtcOrder updateHitbtcOrder(@PathParam(value="clientOrderId") String var1, @FormParam(value="quantity") BigDecimal var2, @FormParam(value="requestClientId") String var3, @FormParam(value="price") BigDecimal var4) throws IOException, HitbtcException;

    @DELETE
    @Path(value="order")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public List<HitbtcOrder> cancelAllOrders(@FormParam(value="symbol") String var1) throws IOException, HitbtcException;

    @DELETE
    @Path(value="order/{clientOrderId}")
    public HitbtcOrder cancelSingleOrder(@PathParam(value="clientOrderId") String var1) throws IOException, HitbtcException;

    @GET
    @Path(value="trading/balance")
    public List<HitbtcBalance> getTradingBalance() throws IOException, HitbtcException;

    @GET
    @Path(value="history/trades")
    public List<HitbtcOwnTrade> getHitbtcTrades() throws IOException, HitbtcException;

    @GET
    @Path(value="history/order")
    public List<HitbtcOrder> getHitbtcRecentOrders() throws IOException, HitbtcException;

    @GET
    @Path(value="/history/order/{id}/trades")
    public List<HitbtcOwnTrade> getHistorialTradesByOrder(@PathParam(value="id") String var1) throws IOException, HitbtcException;
}

