/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.util.List;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.hitbtc.v2.HitbtcAdapters;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcMetaData;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcSymbol;
import org.knowm.xchange.hitbtc.v2.service.HitbtcAccountService;
import org.knowm.xchange.hitbtc.v2.service.HitbtcMarketDataService;
import org.knowm.xchange.hitbtc.v2.service.HitbtcMarketDataServiceRaw;
import org.knowm.xchange.hitbtc.v2.service.HitbtcTradeService;
import org.knowm.xchange.utils.nonce.CurrentTimeNonceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class HitbtcExchange
extends BaseExchange
implements Exchange {
    private final SynchronizedValueFactory<Long> nonceFactory = new CurrentTimeNonceFactory();
    private HitbtcMetaData hitbtcMetaData;
    private static final Logger LOGGER = LoggerFactory.getLogger(HitbtcExchange.class);

    protected void initServices() {
        this.marketDataService = new HitbtcMarketDataService(this);
        this.tradeService = new HitbtcTradeService(this);
        this.accountService = new HitbtcAccountService(this);
    }

    protected void loadExchangeMetaData(InputStream is) {
        this.hitbtcMetaData = (HitbtcMetaData)((Object)this.loadMetaData(is, HitbtcMetaData.class));
        this.exchangeMetaData = HitbtcAdapters.adaptToExchangeMetaData(null, this.hitbtcMetaData.getCurrencies(), this.hitbtcMetaData.getCurrencyPairs());
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        exchangeSpecification.setSslUri("https://api.hitbtc.com");
        exchangeSpecification.setHost("hitbtc.com");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("Hitbtc");
        exchangeSpecification.setExchangeDescription("Hitbtc is a Bitcoin exchange.");
        exchangeSpecification.setExchangeSpecificParametersItem("demo-api", (Object)"http://demo-api.hitbtc.com");
        return exchangeSpecification;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    public void remoteInit() throws IOException {
        List<HitbtcSymbol> hitbtcSymbols = ((HitbtcMarketDataServiceRaw)this.marketDataService).getHitbtcSymbols();
        this.exchangeMetaData = HitbtcAdapters.adaptToExchangeMetaData(hitbtcSymbols, this.hitbtcMetaData.getCurrencies(), this.hitbtcMetaData.getCurrencyPairs());
    }

    private static void setupPatchSupport() {
        try {
            Field methodsField = HttpURLConnection.class.getDeclaredField("methods");
            methodsField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(methodsField, methodsField.getModifiers() & 0xFFFFFFEF);
            String[] methods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "TRACE", "PATCH"};
            methodsField.set(null, methods);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.error("Error while setting up PATCH support");
        }
    }

    static {
        HitbtcExchange.setupPatchSupport();
    }
}

