/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.hitbtc.v2.HitbtcAdapters;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTransaction;
import org.knowm.xchange.hitbtc.v2.service.HitbtcAccountServiceRaw;
import org.knowm.xchange.hitbtc.v2.service.HitbtcTradeHistoryParams;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class HitbtcAccountService
extends HitbtcAccountServiceRaw
implements AccountService {
    public HitbtcAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return new AccountInfo(new Wallet[]{HitbtcAdapters.adaptWallet("Main", this.getMainBalance()), HitbtcAdapters.adaptWallet("Trading", this.getTradingBalance())});
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        return this.withdrawFundsRaw(currency, amount, address);
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.currency, defaultParams.amount, defaultParams.address);
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        return this.getDepositAddress(currency.toString());
    }

    public TradeHistoryParams createFundingHistoryParams() {
        throw new NotAvailableFromExchangeException();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        List<HitbtcTransaction> transactions;
        if (params instanceof TradeHistoryParams) {
            HitbtcTradeHistoryParams hitbtcTradeHistoryParams = (HitbtcTradeHistoryParams)params;
            String currency = hitbtcTradeHistoryParams.getCurrency() != null ? hitbtcTradeHistoryParams.getCurrency().getCurrencyCode() : null;
            transactions = this.getTransactions(currency, hitbtcTradeHistoryParams.getLimit(), hitbtcTradeHistoryParams.getOffset());
        } else {
            transactions = this.getTransactions(null, null, null);
        }
        ArrayList<FundingRecord> records = new ArrayList<FundingRecord>();
        for (HitbtcTransaction transaction : transactions) {
            records.add(HitbtcAdapters.adapt(transaction));
        }
        return records;
    }
}

