/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcAddress;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcBalance;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcInternalTransferResponse;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTransaction;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTransferType;
import org.knowm.xchange.hitbtc.v2.service.HitbtcBaseService;
import si.mazi.rescu.HttpStatusIOException;

public class HitbtcAccountServiceRaw
extends HitbtcBaseService {
    public HitbtcAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public String withdrawFundsRaw(Currency currency, BigDecimal amount, String address) throws HttpStatusIOException {
        Map response = this.hitbtc.payout(amount, currency.getCurrencyCode(), address);
        return response.get("transaction").toString();
    }

    public HitbtcInternalTransferResponse transferFunds(Currency currency, BigDecimal amount, HitbtcTransferType hitbtcTransferType) throws IOException {
        return this.hitbtc.transferToTrading(amount, currency.getCurrencyCode(), hitbtcTransferType.getType());
    }

    public String transferToTrading(Currency currency, BigDecimal amount) throws IOException {
        HitbtcInternalTransferResponse response = this.transferFunds(currency, amount, HitbtcTransferType.BANK_TO_EXCHANGE);
        if (response.id == null) {
            throw new ExchangeException("transfer failed: " + response);
        }
        return response.id;
    }

    public String transferToMain(Currency currency, BigDecimal amount) throws IOException {
        HitbtcInternalTransferResponse response = this.transferFunds(currency, amount, HitbtcTransferType.EXCHANGE_TO_BANK);
        if (response.id == null) {
            throw new ExchangeException("transfer failed: " + response);
        }
        return response.id;
    }

    public List<HitbtcBalance> getMainBalance() throws IOException {
        return this.hitbtc.getMainBalance();
    }

    public List<HitbtcBalance> getTradingBalance() throws IOException {
        return this.hitbtc.getTradingBalance();
    }

    public String getDepositAddress(String currency) throws IOException {
        HitbtcAddress hitbtcDepositAddress = this.hitbtc.getHitbtcDepositAddress(currency);
        return hitbtcDepositAddress.getAddress();
    }

    public List<HitbtcTransaction> getTransactions(String currency, Integer limit, Integer offset) throws HttpStatusIOException {
        return this.hitbtc.transactions(currency, limit, offset);
    }
}

