/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.hitbtc.v2.HitbtcAdapters;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcSort;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTrade;
import org.knowm.xchange.hitbtc.v2.service.HitbtcMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class HitbtcMarketDataService
extends HitbtcMarketDataServiceRaw
implements MarketDataService {
    public HitbtcMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        return HitbtcAdapters.adaptTicker(this.getHitbtcTicker(currencyPair), currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        return HitbtcAdapters.adaptOrderBook(this.getHitbtcOrderBook(currencyPair), currencyPair);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        if (args == null || args.length == 0) {
            return HitbtcAdapters.adaptTrades(this.getHitbtcTrades(currencyPair), currencyPair);
        }
        long from = (Long)args[0];
        HitbtcTrade.HitbtcTradesSortField sortBy = (HitbtcTrade.HitbtcTradesSortField)((Object)args[1]);
        HitbtcSort sortDirection = (HitbtcSort)((Object)args[2]);
        long startIndex = (Long)args[3];
        long max_results = (Long)args[4];
        return HitbtcAdapters.adaptTrades(this.getHitbtcTrades(currencyPair, from, sortBy, sortDirection, startIndex, max_results), currencyPair);
    }
}

