/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.hitbtc.v2.HitbtcAdapters;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcCandle;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrderBook;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcSort;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcSymbol;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTicker;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcTrade;
import org.knowm.xchange.hitbtc.v2.service.HitbtcBaseService;

public class HitbtcMarketDataServiceRaw
extends HitbtcBaseService {
    public HitbtcMarketDataServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public List<HitbtcSymbol> getHitbtcSymbols() throws IOException {
        return this.hitbtc.getSymbols();
    }

    public Map<String, HitbtcTicker> getHitbtcTickers() throws IOException {
        return this.hitbtc.getHitbtcTickers().stream().collect(Collectors.toMap(hitbtcTicker -> hitbtcTicker.getSymbol(), hitbtcTicker -> hitbtcTicker));
    }

    public HitbtcTicker getHitbtcTicker(CurrencyPair currencyPair) throws IOException {
        return this.hitbtc.getTicker(HitbtcAdapters.adaptCurrencyPair(currencyPair));
    }

    public HitbtcOrderBook getHitbtcOrderBook(CurrencyPair currencyPair) throws IOException {
        return this.hitbtc.getOrderBook(HitbtcAdapters.adaptCurrencyPair(currencyPair));
    }

    public List<HitbtcTrade> getHitbtcTrades(CurrencyPair currencyPair) throws IOException {
        return this.getHitbtcTrades(currencyPair, 100L, HitbtcTrade.HitbtcTradesSortField.SORT_BY_TRADE_ID, HitbtcSort.SORT_ASCENDING, 0L, 100L);
    }

    public List<HitbtcTrade> getHitbtcTrades(CurrencyPair currencyPair, long from, HitbtcTrade.HitbtcTradesSortField sortBy, HitbtcSort sortDirection, long startIndex, long maxResults) throws IOException {
        return this.hitbtc.getTrades(HitbtcAdapters.adaptCurrencyPair(currencyPair));
    }

    public List<HitbtcCandle> getHitbtcCandles(CurrencyPair currencyPair, int limit, String period) throws IOException {
        return this.hitbtc.getHitbtcOHLC(HitbtcAdapters.adaptCurrencyPair(currencyPair), limit, period);
    }
}

