/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2.service;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.hitbtc.v2.HitbtcAdapters;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrder;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOwnTrade;
import org.knowm.xchange.hitbtc.v2.service.HitbtcTradeHistoryParams;
import org.knowm.xchange.hitbtc.v2.service.HitbtcTradeServiceRaw;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrencyPair;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;

public class HitbtcTradeService
extends HitbtcTradeServiceRaw
implements TradeService {
    public HitbtcTradeService(Exchange exchange) {
        super(exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        return this.getOpenOrders(this.createOpenOrdersParams());
    }

    public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        List<HitbtcOrder> openOrdersRaw = this.getOpenOrdersRaw();
        return HitbtcAdapters.adaptOpenOrders(openOrdersRaw);
    }

    public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        return this.placeMarketOrderRaw((MarketOrder)marketOrder).clientOrderId;
    }

    public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        return this.placeLimitOrderRaw((LimitOrder)limitOrder).clientOrderId;
    }

    public boolean cancelOrder(String orderId) throws IOException {
        HitbtcOrder cancelOrderRaw = this.cancelOrderRaw(orderId);
        return "canceled".equals(cancelOrderRaw.status);
    }

    public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        if (orderParams instanceof CancelOrderByIdParams) {
            return this.cancelOrder(((CancelOrderByIdParams)orderParams).getOrderId());
        }
        return false;
    }

    public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        int count = 1000;
        int offset = 0;
        if (params instanceof TradeHistoryParamPaging) {
            Integer pageNumber;
            TradeHistoryParamPaging pagingParams = (TradeHistoryParamPaging)params;
            if (pagingParams.getPageLength() != null) {
                count = pagingParams.getPageLength();
            }
            offset = count * ((pageNumber = pagingParams.getPageNumber()) != null ? pageNumber : 0);
        }
        String symbols = null;
        if (params instanceof TradeHistoryParamCurrencyPair) {
            TradeHistoryParamCurrencyPair tradeHistoryParamCurrencyPair = (TradeHistoryParamCurrencyPair)params;
            CurrencyPair pair = tradeHistoryParamCurrencyPair.getCurrencyPair();
            symbols = HitbtcAdapters.adaptCurrencyPair(pair);
        }
        List<HitbtcOwnTrade> tradeHistoryRaw = this.getTradeHistoryRaw(offset, count, symbols);
        return HitbtcAdapters.adaptTradeHistory(tradeHistoryRaw, this.exchange.getExchangeMetaData());
    }

    public TradeHistoryParams createTradeHistoryParams() {
        return HitbtcTradeHistoryParams.builder().build();
    }

    public OpenOrdersParams createOpenOrdersParams() {
        return null;
    }

    public Collection<Order> getOrder(String ... orderIds) throws IOException {
        throw new NotYetImplementedForExchangeException();
    }

    public void verifyOrder(LimitOrder limitOrder) {
        throw new NotYetImplementedForExchangeException();
    }

    public void verifyOrder(MarketOrder marketOrder) {
        throw new NotYetImplementedForExchangeException();
    }
}

