/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.hitbtc.v2.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.hitbtc.v2.HitbtcAdapters;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcBalance;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrder;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOwnTrade;
import org.knowm.xchange.hitbtc.v2.service.HitbtcBaseService;

public class HitbtcTradeServiceRaw
extends HitbtcBaseService {
    public HitbtcTradeServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public List<HitbtcOrder> getOpenOrdersRaw() throws IOException {
        return this.hitbtc.getHitbtcActiveOrders();
    }

    public HitbtcOrder placeMarketOrderRaw(MarketOrder marketOrder) throws IOException {
        String symbol = marketOrder.getCurrencyPair().base.getCurrencyCode() + marketOrder.getCurrencyPair().counter.getCurrencyCode();
        String side = HitbtcAdapters.getSide(marketOrder.getType()).toString();
        return this.hitbtc.postHitbtcNewOrder(null, symbol, side, null, marketOrder.getOriginalAmount(), "market", "IOC");
    }

    public HitbtcOrder placeLimitOrderRaw(LimitOrder limitOrder) throws IOException {
        String symbol = HitbtcAdapters.adaptCurrencyPair(limitOrder.getCurrencyPair());
        String side = HitbtcAdapters.getSide(limitOrder.getType()).toString();
        return this.hitbtc.postHitbtcNewOrder(null, symbol, side, limitOrder.getLimitPrice(), limitOrder.getOriginalAmount(), "limit", "GTC");
    }

    public HitbtcOrder updateMarketOrderRaw(String clientOrderId, BigDecimal quantity, String requestClientId, Optional<BigDecimal> price) throws IOException {
        return this.hitbtc.updateHitbtcOrder(clientOrderId, quantity, requestClientId, price.orElse(null));
    }

    public HitbtcOrder cancelOrderRaw(String clientOrderId) throws IOException {
        return this.hitbtc.cancelSingleOrder(clientOrderId);
    }

    public List<HitbtcOrder> cancelAllOrdersRaw(String symbol) throws IOException {
        return this.hitbtc.cancelAllOrders(symbol);
    }

    public List<HitbtcOwnTrade> getTradeHistoryRaw(int startIndex, int maxResults, String symbols) throws IOException {
        return this.hitbtc.getHitbtcTrades();
    }

    public List<HitbtcBalance> getTradingBalance() throws IOException {
        return this.hitbtc.getTradingBalance();
    }
}

