/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.common;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.util.StringUtils;

public class AntMavenUtils {
    public static final String MVN_COMPILE_CLASSPATH_KEY = "maven.compile.classpath";
    public static final String MVN_RUNTIME_CLASSPATH_KEY = "maven.runtime.classpath";
    public static final String MVN_TEST_CLASSPATH_KEY = "maven.test.classpath";
    public static final String MVN_PLUGIN_CLASSPATH_KEY = "maven.plugin.classpath";

    public void copyProperties(Project antProject, MavenProject mavenProject, Log log) {
        log.debug((CharSequence)"Propagated Ant properties to Maven properties");
        Hashtable antProps = antProject.getProperties();
        for (String key : antProps.keySet()) {
            Properties mavenProperties = mavenProject.getProperties();
            if (mavenProperties.getProperty(key) != null) {
                log.debug((CharSequence)("Ant property '" + key + "=" + mavenProperties.getProperty(key) + "' clashes with an existing Maven property, SKIPPING this Ant property propagation."));
                continue;
            }
            mavenProperties.setProperty(key, antProps.get(key).toString());
        }
    }

    public Path getPathFromArtifacts(Collection<Artifact> artifacts, Project antProject) throws DependencyResolutionRequiredException {
        if (artifacts == null) {
            return new Path(antProject);
        }
        ArrayList<String> list = new ArrayList<String>(artifacts.size());
        for (Artifact a : artifacts) {
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        Path p = new Path(antProject);
        p.setPath(StringUtils.join(list.iterator(), (String)File.pathSeparator));
        return p;
    }

    public void copyProperties(MavenProject mavenProject, Project antProject, String prefix, Log log, ArtifactRepository localRepo) {
        Properties mavenProps = mavenProject.getProperties();
        for (String string : mavenProps.keySet()) {
            antProject.setProperty(string, mavenProps.getProperty(string));
        }
        antProject.setProperty("ant.file", mavenProject.getFile().getAbsolutePath());
        log.debug((CharSequence)("Setting properties with prefix: " + prefix));
        antProject.setProperty(prefix + "project.groupId", mavenProject.getGroupId());
        antProject.setProperty(prefix + "project.artifactId", mavenProject.getArtifactId());
        antProject.setProperty(prefix + "project.name", mavenProject.getName());
        if (mavenProject.getDescription() != null) {
            antProject.setProperty(prefix + "project.description", mavenProject.getDescription());
        }
        antProject.setProperty(prefix + "project.version", mavenProject.getVersion());
        antProject.setProperty(prefix + "project.packaging", mavenProject.getPackaging());
        antProject.setProperty(prefix + "project.build.directory", mavenProject.getBuild().getDirectory());
        antProject.setProperty(prefix + "project.basedir", mavenProject.getBasedir().getAbsolutePath());
        antProject.setProperty(prefix + "project.build.outputDirectory", mavenProject.getBuild().getOutputDirectory());
        antProject.setProperty(prefix + "project.build.testOutputDirectory", mavenProject.getBuild().getTestOutputDirectory());
        antProject.setProperty(prefix + "project.build.sourceDirectory", mavenProject.getBuild().getSourceDirectory());
        antProject.setProperty(prefix + "project.build.testSourceDirectory", mavenProject.getBuild().getTestSourceDirectory());
        antProject.setProperty(prefix + "localRepository", localRepo.toString());
        antProject.setProperty(prefix + "settings.localRepository", localRepo.getBasedir());
        Set set = mavenProject.getArtifacts();
        for (Artifact artifact : set) {
            String propName = artifact.getDependencyConflictId();
            antProject.setProperty(prefix + propName, artifact.getFile().getPath());
        }
    }

    public BuildLogger getBuildLogger(Log logger) {
        DefaultLogger antLogger = new DefaultLogger();
        antLogger.setOutputPrintStream(System.out);
        antLogger.setErrorPrintStream(System.err);
        if (logger.isDebugEnabled()) {
            antLogger.setMessageOutputLevel(4);
        } else if (logger.isInfoEnabled()) {
            antLogger.setMessageOutputLevel(2);
        } else if (logger.isWarnEnabled()) {
            antLogger.setMessageOutputLevel(1);
        } else if (logger.isErrorEnabled()) {
            antLogger.setMessageOutputLevel(0);
        } else {
            antLogger.setMessageOutputLevel(3);
        }
        return antLogger;
    }

    public Map<String, Path> getPathRefs(Project ant, MavenProject mvn, List<Artifact> pluginArtifacts) throws DependencyResolutionRequiredException {
        HashMap<String, Path> pathRefs = new HashMap<String, Path>();
        Path mcp = new Path(ant);
        mcp.setPath(StringUtils.join(mvn.getCompileClasspathElements().iterator(), (String)File.pathSeparator));
        pathRefs.put(MVN_COMPILE_CLASSPATH_KEY, mcp);
        Path mrp = new Path(ant);
        mrp.setPath(StringUtils.join(mvn.getRuntimeClasspathElements().iterator(), (String)File.pathSeparator));
        pathRefs.put(MVN_RUNTIME_CLASSPATH_KEY, mrp);
        Path mtp = new Path(ant);
        mtp.setPath(StringUtils.join(mvn.getTestClasspathElements().iterator(), (String)File.pathSeparator));
        pathRefs.put(MVN_TEST_CLASSPATH_KEY, mtp);
        Path mpp = this.getPathFromArtifacts(pluginArtifacts, ant);
        pathRefs.put(MVN_PLUGIN_CLASSPATH_KEY, mpp);
        return pathRefs;
    }

    public void addRefs(Project antProject, Map<String, ?> refs) {
        for (Map.Entry<String, ?> pair : refs.entrySet()) {
            antProject.addReference(pair.getKey(), pair.getValue());
        }
    }

    public void setPathProperties(Project antProject, Map<String, Path> paths) {
        for (Map.Entry<String, Path> pair : paths.entrySet()) {
            antProject.setProperty(pair.getKey(), pair.getValue().toString());
        }
    }
}

