/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.ldaptive.SortBehavior;
import org.ldaptive.beans.Attribute;
import org.ldaptive.beans.AttributeValueMutator;
import org.ldaptive.io.ValueTranscoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpelAttributeValueMutator
implements AttributeValueMutator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Attribute attribute;
    private final Expression expression;
    private final EvaluationContext evaluationContext;
    private final ValueTranscoder transcoder;

    public SpelAttributeValueMutator(Attribute attr, EvaluationContext context) {
        this.attribute = attr;
        SpelExpressionParser parser = new SpelExpressionParser();
        this.expression = parser.parseExpression(this.attribute.property().length() > 0 ? this.attribute.property() : this.attribute.name());
        this.evaluationContext = context;
        this.transcoder = "".equals(this.attribute.transcoder()) ? null : (ValueTranscoder)parser.parseExpression(this.attribute.transcoder()).getValue(ValueTranscoder.class);
    }

    @Override
    public String getName() {
        return this.attribute.name();
    }

    @Override
    public boolean isBinary() {
        return this.attribute.binary();
    }

    @Override
    public SortBehavior getSortBehavior() {
        return this.attribute.sortBehavior();
    }

    @Override
    public Collection<String> getStringValues(Object object) {
        return this.getValues(object, String.class);
    }

    @Override
    public Collection<byte[]> getBinaryValues(Object object) {
        return this.getValues(object, byte[].class);
    }

    protected <T> Collection<T> getValues(Object object, Class<T> type) {
        Collection<T> values = null;
        Object converted = this.expression.getValue(this.evaluationContext, object);
        if (converted != null) {
            if (converted instanceof byte[] || converted instanceof char[]) {
                values = SpelAttributeValueMutator.createCollection(List.class, 1);
                T value = this.convertValue(converted, converted.getClass(), type);
                if (value != null) {
                    values.add(value);
                }
            } else if (converted.getClass().isArray()) {
                int length = Array.getLength(converted);
                values = SpelAttributeValueMutator.createCollection(List.class, length);
                for (int i = 0; i < length; ++i) {
                    T value;
                    Object o = Array.get(converted, i);
                    if (o == null || (value = this.convertValue(o, o.getClass(), type)) == null) continue;
                    values.add(value);
                }
            } else if (Collection.class.isAssignableFrom(converted.getClass())) {
                Collection col = (Collection)converted;
                values = SpelAttributeValueMutator.createCollection(converted.getClass(), col.size());
                for (Object o : col) {
                    T value;
                    if (o == null || (value = this.convertValue(o, o.getClass(), type)) == null) continue;
                    values.add(value);
                }
            } else {
                values = SpelAttributeValueMutator.createCollection(List.class, 1);
                T value = this.convertValue(converted, converted.getClass(), type);
                if (value != null) {
                    values.add(value);
                }
            }
        }
        return values;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T> T convertValue(Object value, Class<?> sourceType, Class<T> targetType) {
        void var4_7;
        if (this.transcoder != null) {
            if (byte[].class == targetType) {
                byte[] byArray = this.transcoder.encodeBinaryValue(value);
                return var4_7;
            } else {
                if (String.class != targetType) throw new IllegalArgumentException("targetType must be either String.class or byte[].class");
                String string = this.transcoder.encodeStringValue(value);
            }
            return var4_7;
        } else {
            Object object = this.evaluationContext.getTypeConverter().convertValue(value, TypeDescriptor.valueOf(sourceType), TypeDescriptor.valueOf(targetType));
        }
        return var4_7;
    }

    @Override
    public void setStringValues(Object object, Collection<String> values) {
        this.setValues(object, values, String.class);
    }

    @Override
    public void setBinaryValues(Object object, Collection<byte[]> values) {
        this.setValues(object, values, byte[].class);
    }

    protected <T> void setValues(Object object, Collection<T> values, Class<T> type) {
        if (this.transcoder != null) {
            Collection<T> newValues = SpelAttributeValueMutator.createCollection(values.getClass(), values.size());
            for (T t : values) {
                if (byte[].class == type) {
                    newValues.add(this.transcoder.decodeBinaryValue((byte[])t));
                    continue;
                }
                if (String.class == type) {
                    newValues.add(this.transcoder.decodeStringValue((String)t));
                    continue;
                }
                throw new IllegalArgumentException("type must be either String.class or byte[].class");
            }
            this.expression.setValue(this.evaluationContext, object, newValues);
        } else if (values != null && values.size() == 1) {
            this.expression.setValue(this.evaluationContext, object, values.iterator().next());
        } else {
            this.expression.setValue(this.evaluationContext, object, values);
        }
    }

    public String toString() {
        return String.format("[%s@%d::attribute=%s, expression=%s, evaluationContext=%s, transcoder=%s]", this.getClass().getName(), this.hashCode(), this.attribute, this.expression, this.evaluationContext, this.transcoder);
    }

    protected static <T> Collection<T> createCollection(Class<?> type, int size) {
        AbstractCollection c = List.class.isAssignableFrom(type) ? (LinkedList.class.isAssignableFrom(type) ? new LinkedList() : new ArrayList(size)) : (Set.class.isAssignableFrom(type) ? (LinkedHashSet.class.isAssignableFrom(type) ? new LinkedHashSet(size) : (TreeSet.class.isAssignableFrom(type) ? new TreeSet() : new HashSet(size))) : new ArrayList(size));
        return c;
    }
}

