/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring.parser;

import org.ldaptive.beans.spring.parser.AbstractSearchAuthenticatorBeanDefinitionParser;
import org.ldaptive.sasl.CramMd5Config;
import org.ldaptive.sasl.DigestMd5Config;
import org.ldaptive.sasl.ExternalConfig;
import org.ldaptive.sasl.GssApiConfig;
import org.ldaptive.sasl.SaslConfig;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class SaslBindSearchAuthenticatorBeanDefinitionParser
extends AbstractSearchAuthenticatorBeanDefinitionParser {
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String idAttrValue = element.getAttribute("id");
        return StringUtils.hasText((String)idAttrValue) ? idAttrValue : "sasl-bind-search-authenticator";
    }

    @Override
    protected BeanDefinitionBuilder parseConnectionInitializer(BeanDefinitionBuilder builder, Element element) {
        BeanDefinitionBuilder initializer = super.parseConnectionInitializer(builder, element);
        initializer.addPropertyValue("bindSaslConfig", (Object)this.parseSaslConfig(element).getBeanDefinition());
        return initializer;
    }

    protected BeanDefinitionBuilder parseSaslConfig(Element element) {
        BeanDefinitionBuilder saslConfig = BeanDefinitionBuilder.rootBeanDefinition(SaslBindSearchAuthenticatorBeanDefinitionParser.class, (String)"parseSaslConfig");
        saslConfig.addConstructorArgValue((Object)element.getAttribute("mechanism"));
        this.setIfPresent(element, "realm", saslConfig);
        this.setIfPresent(element, "authorizationId", saslConfig);
        this.setIfPresent(element, "mutualAuthentication", saslConfig);
        this.setIfPresent(element, "qualityOfProtection", saslConfig);
        this.setIfPresent(element, "securityStrength", saslConfig);
        return saslConfig;
    }

    protected static SaslConfig parseSaslConfig(String value) {
        DigestMd5Config saslConfig;
        switch (value) {
            case "DIGEST_MD5": {
                saslConfig = new DigestMd5Config();
                break;
            }
            case "CRAM_MD5": {
                saslConfig = new CramMd5Config();
                break;
            }
            case "EXTERNAL": {
                saslConfig = new ExternalConfig();
                break;
            }
            case "GSSAPI": {
                saslConfig = new GssApiConfig();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SASL mechanism " + value);
            }
        }
        return saslConfig;
    }
}

