/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.dom;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DomHelper {
    public static XPath xpath = XPathFactory.newInstance().newXPath();
    static final String GROUP_ELEMENT_NAME = "Group";
    static final String ENTRY_ELEMENT_NAME = "Entry";
    static final String ICON_ELEMENT_NAME = "IconID";
    static final String UUID_ELEMENT_NAME = "UUID";
    static final String NAME_ELEMENT_NAME = "Name";
    static final String NOTES_ELEMENT_NAME = "Notes";
    static final String TIMES_ELEMENT_NAME = "Times";
    static final String IS_EXPANDED = "IsExpanded";
    static final String HISTORY_ELEMENT_NAME = "History";
    static final String LAST_MODIFICATION_TIME_ELEMENT_NAME = "Times/LastModificationTime";
    static final String CREATION_TIME_ELEMENT_NAME = "Times/CreationTime";
    static final String LAST_ACCESS_TIME_ELEMENT_NAME = "Times/LastAccessTime";
    static final String EXPIRY_TIME_ELEMENT_NAME = "Times/ExpiryTime";
    static final String EXPIRES_ELEMENT_NAME = "Times/Expires";
    static final String USAGE_COUNT_ELEMENT_NAME = "Times/UsageCount";
    static final String LOCATION_CHANGED = "Times/LocationChanged";
    static final String PROPERTY_ELEMENT_FORMAT = "String[Key/text()='%s']";
    static final String BINARY_PROPERTY_ELEMENT_FORMAT = "Binary[Key/text()='%s']";
    static final String VALUE_ELEMENT_NAME = "Value";
    static final String RECYCLE_BIN_UUID_ELEMENT_NAME = "RecycleBinUuid";
    static final String RECYCLE_BIN_ENABLED_ELEMENT_NAME = "RecycleBinEnabled";
    static final String RECYCLE_BIN_CHANGED_ELEMENT_NAME = "RecycleBinChanged";

    static void ensureElements(Element element, Map<String, ValueCreator> childElements) {
        for (Map.Entry<String, ValueCreator> entry : childElements.entrySet()) {
            DomHelper.ensureElementContent(entry.getKey(), element, entry.getValue().getValue());
        }
    }

    @Nullable
    @Contract(value="_,_,true -> !null")
    static Element getElement(String elementPath, Element parentElement, boolean create) {
        try {
            Element result = (Element)xpath.evaluate(elementPath, parentElement, XPathConstants.NODE);
            if (result == null && create) {
                result = DomHelper.createHierarchically(elementPath, parentElement);
            }
            return result;
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }

    static boolean removeElement(String elementPath, Element parentElement) {
        Element toRemove = DomHelper.getElement(elementPath, parentElement, false);
        if (toRemove == null) {
            return false;
        }
        toRemove.getParentNode().removeChild(toRemove);
        return true;
    }

    static List<Element> getElements(String elementPath, Element parentElement) {
        try {
            NodeList nodes = (NodeList)xpath.evaluate(elementPath, parentElement, XPathConstants.NODESET);
            ArrayList<Element> result = new ArrayList<Element>(nodes.getLength());
            for (int i = 0; i < nodes.getLength(); ++i) {
                result.add((Element)nodes.item(i));
            }
            return result;
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }

    static int getElementsCount(String elementPath, Element parentElement) {
        try {
            NodeList nodes = (NodeList)xpath.evaluate(elementPath, parentElement, XPathConstants.NODESET);
            return nodes.getLength();
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    static Element newElement(String elementName, Element parentElement) {
        Element newElement = parentElement.getOwnerDocument().createElement(elementName);
        parentElement.appendChild(newElement);
        return newElement;
    }

    @Nullable
    public static String getElementContent(String elementPath, Element parentElement) {
        Element result = DomHelper.getElement(elementPath, parentElement, false);
        return result == null ? null : result.getTextContent();
    }

    @NotNull
    public static String ensureElementContent(String elementPath, Element parentElement, @NotNull String value) {
        Element result = DomHelper.getElement(elementPath, parentElement, false);
        if (result == null) {
            result = DomHelper.createHierarchically(elementPath, parentElement);
        }
        result.setTextContent(value);
        return result.getTextContent();
    }

    @NotNull
    public static Element setElementContent(String elementPath, Element parentElement, String value) {
        Element result = DomHelper.getElement(elementPath, parentElement, true);
        result.setTextContent(value);
        return result;
    }

    @Nullable
    static byte[] getBinaryElementContent(String elementPath, Element parentElement) {
        Element result = DomHelper.getElement(elementPath, parentElement, false);
        if (result == null) {
            return null;
        }
        String id = result.getAttribute("Ref");
        Element content = DomHelper.getElement("//Binaries/Binary[@ID=" + id + "]", parentElement.getOwnerDocument().getDocumentElement(), false);
        if (content == null) {
            throw new IllegalStateException("Could not find binary content with ID " + id);
        }
        return Helpers.decodeBase64Content(content.getTextContent().getBytes(), content.hasAttribute("Compressed"));
    }

    @NotNull
    static Element setBinaryElementContent(String elementPath, Element parentElement, byte[] value) {
        try {
            String b64 = Helpers.encodeBase64Content(value, true);
            String max = xpath.evaluate("//Binaries/Binary/@ID[not(. < ../../Binary/@ID)][1]", parentElement.getOwnerDocument().getDocumentElement());
            if (max.trim().isEmpty()) {
                max = "-1";
            }
            Integer newIndex = Integer.valueOf(max) + 1;
            DomHelper.addBinary(parentElement.getOwnerDocument().getDocumentElement(), b64, newIndex);
            Element result = DomHelper.getElement(elementPath, parentElement, true);
            result.setAttribute("Ref", newIndex.toString());
            return result;
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void addBinary(Element documentElement, String b64, Integer index) {
        Element binaries = DomHelper.getElement("Meta/Binaries", documentElement, true);
        Element binary = (Element)binaries.appendChild(binaries.getOwnerDocument().createElement("Binary"));
        binary.setTextContent(b64);
        binary.setAttribute("Compressed", "True");
        binary.setAttribute("ID", index.toString());
    }

    public static String getBinary(Element documentElement, Integer index) {
        Element binaries = DomHelper.getElement("Meta/Binaries", documentElement, false);
        if (Objects.isNull(binaries)) {
            throw new IllegalArgumentException("No binaries found");
        }
        for (int i = 0; i < binaries.getChildNodes().getLength(); ++i) {
            if (!((Element)binaries.getChildNodes().item(i)).getAttribute("ID").equals(index.toString())) continue;
            return ((Element)binaries.getChildNodes().item(i)).getTextContent();
        }
        throw new IllegalArgumentException("No binary with that index found");
    }

    public static int getBinaryCount(Element documentElement) {
        Element binaries = DomHelper.getElement("Meta/Binaries", documentElement, false);
        if (Objects.isNull(binaries)) {
            return 0;
        }
        return binaries.getChildNodes().getLength();
    }

    @NotNull
    static Element touchElement(String elementPath, Element parentElement) {
        return DomHelper.setElementContent(elementPath, parentElement, Helpers.fromDate(new Date()));
    }

    private static Element createHierarchically(String elementPath, Element startElement) {
        Element currentElement = startElement;
        for (String elementName : elementPath.split("/")) {
            try {
                Element nextElement = (Element)xpath.evaluate(elementName, currentElement, XPathConstants.NODE);
                if (nextElement == null) {
                    nextElement = (Element)currentElement.appendChild(currentElement.getOwnerDocument().createElement(elementName));
                }
                currentElement = nextElement;
            }
            catch (XPathExpressionException e) {
                throw new IllegalStateException(e);
            }
        }
        return currentElement;
    }

    static String base64RandomUuid() {
        return Helpers.base64FromUuid(UUID.randomUUID());
    }

    static class UuidValueCreator
    implements ValueCreator {
        UuidValueCreator() {
        }

        @Override
        public String getValue() {
            return DomHelper.base64RandomUuid();
        }
    }

    static class DateValueCreator
    implements ValueCreator {
        DateValueCreator() {
        }

        @Override
        public String getValue() {
            return Helpers.fromDate(Date.from(Instant.now()));
        }
    }

    static class ConstantValueCreator
    implements ValueCreator {
        String value;

        ConstantValueCreator(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    static interface ValueCreator {
        public String getValue();
    }
}

