/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.core.UnknownType;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Relation;
import liquibase.util.SqlUtil;
import liquibase.util.StringUtil;
import org.hibernate.boot.Metadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.id.ExportableColumn;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;

public class ColumnSnapshotGenerator
extends HibernateSnapshotGenerator {
    private static final Pattern pattern = Pattern.compile("([^\\(]*)\\s*\\(?\\s*(\\d*)?\\s*,?\\s*(\\d*)?\\s*([^\\(]*?)\\)?");

    public ColumnSnapshotGenerator() {
        super(liquibase.structure.core.Column.class, new Class[]{liquibase.structure.core.Table.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        liquibase.structure.core.Column column = (liquibase.structure.core.Column)example;
        if (column.getType() == null) {
            if (column.getRelation() == null) {
                throw new InvalidExampleException("No relation set on " + column);
            }
            Relation relation = (Relation)snapshot.get((DatabaseObject)column.getRelation());
            if (relation != null) {
                for (liquibase.structure.core.Column columnSnapshot : relation.getColumns()) {
                    if (!columnSnapshot.getName().equalsIgnoreCase(column.getName())) continue;
                    return columnSnapshot;
                }
            }
            this.snapshotColumn((liquibase.structure.core.Column)example, snapshot);
            return example;
        }
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (foundObject instanceof liquibase.structure.core.Table) {
            Table hibernateTable = this.findHibernateTable(foundObject, snapshot);
            if (hibernateTable == null) {
                return;
            }
            Iterator<Column> columnIterator = hibernateTable.getColumnIterator();
            while (columnIterator.hasNext()) {
                Column hibernateColumn = columnIterator.next();
                liquibase.structure.core.Column column = new liquibase.structure.core.Column();
                column.setName(hibernateColumn.getName());
                column.setRelation((Relation)((liquibase.structure.core.Table)foundObject));
                this.snapshotColumn(column, snapshot);
                ((liquibase.structure.core.Table)foundObject).getColumns().add(column);
            }
        }
    }

    protected void snapshotColumn(liquibase.structure.core.Column column, DatabaseSnapshot snapshot) throws DatabaseException {
        HibernateDatabase database = (HibernateDatabase)snapshot.getDatabase();
        Table hibernateTable = this.findHibernateTable((DatabaseObject)column.getRelation(), snapshot);
        if (hibernateTable == null) {
            return;
        }
        Dialect dialect = database.getDialect();
        Metadata metadata = database.getMetadata();
        Iterator<Column> columnIterator = hibernateTable.getColumnIterator();
        while (columnIterator.hasNext()) {
            DataType dataType;
            Column hibernateColumn = columnIterator.next();
            if (!hibernateColumn.getName().equalsIgnoreCase(column.getName())) continue;
            String defaultValue = null;
            String hibernateType = hibernateColumn.getSqlType(dialect, metadata);
            Matcher defaultValueMatcher = Pattern.compile("(?i) DEFAULT\\s+(.*)").matcher(hibernateType);
            if (defaultValueMatcher.find()) {
                defaultValue = defaultValueMatcher.group(1);
                hibernateType = hibernateType.replace(defaultValueMatcher.group(0), "");
            }
            if ((dataType = this.toDataType(hibernateType, hibernateColumn.getSqlTypeCode())) == null) {
                throw new DatabaseException("Unable to find column data type for column " + hibernateColumn.getName());
            }
            column.setType(dataType);
            Scope.getCurrentScope().getLog(this.getClass()).info("Found column " + column.getName() + " " + column.getType().toString());
            column.setRemarks(hibernateColumn.getComment());
            if (hibernateColumn.getValue() instanceof SimpleValue) {
                DataType parseType = DataTypeFactory.getInstance().from(dataType, (Database)database) instanceof UnknownType ? new DataType(((SimpleValue)hibernateColumn.getValue()).getTypeName()) : dataType;
                if (defaultValue == null) {
                    defaultValue = hibernateColumn.getDefaultValue();
                }
                column.setDefaultValue(SqlUtil.parseValue((Database)snapshot.getDatabase(), (Object)defaultValue, (DataType)parseType));
            } else {
                column.setDefaultValue((Object)hibernateColumn.getDefaultValue());
            }
            column.setNullable(Boolean.valueOf(hibernateColumn.isNullable()));
            column.setCertainDataType(false);
            PrimaryKey hibernatePrimaryKey = hibernateTable.getPrimaryKey();
            if (hibernatePrimaryKey != null) {
                boolean isPrimaryKeyColumn = false;
                for (Column pkColumn : hibernatePrimaryKey.getColumns()) {
                    if (!pkColumn.getName().equalsIgnoreCase(hibernateColumn.getName())) continue;
                    isPrimaryKeyColumn = true;
                    break;
                }
                if (isPrimaryKeyColumn) {
                    if (!(hibernateColumn instanceof ExportableColumn)) {
                        Properties prop;
                        String identifierGeneratorStrategy;
                        String string = identifierGeneratorStrategy = hibernateColumn.getValue().isSimpleValue() ? ((SimpleValue)hibernateColumn.getValue()).getIdentifierGeneratorStrategy() : null;
                        if ("native".equalsIgnoreCase(identifierGeneratorStrategy) || "identity".equalsIgnoreCase(identifierGeneratorStrategy)) {
                            if (PostgreSQL81Dialect.class.isAssignableFrom(dialect.getClass())) {
                                column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                                String sequenceName = (column.getRelation().getName() + "_" + column.getName() + "_seq").toLowerCase();
                                column.setDefaultValue((Object)new DatabaseFunction("nextval('" + sequenceName + "'::regclass)"));
                            } else if (database.supportsAutoIncrement()) {
                                column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                            }
                        } else if ("org.hibernate.id.enhanced.SequenceStyleGenerator".equals(identifierGeneratorStrategy) && (prop = ((SimpleValue)hibernateColumn.getValue()).getIdentifierGeneratorProperties()).get("sequence_name") == null) {
                            column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                        }
                    }
                    column.setNullable(Boolean.valueOf(false));
                }
            }
            return;
        }
    }

    protected DataType toDataType(String hibernateType, Integer sqlTypeCode) throws DatabaseException {
        String extra;
        Matcher matcher = pattern.matcher(hibernateType);
        if (!matcher.matches()) {
            return null;
        }
        DataType dataType = new DataType(matcher.group(1));
        if (matcher.group(3).isEmpty()) {
            if (!matcher.group(2).isEmpty()) {
                dataType.setColumnSize(Integer.valueOf(Integer.parseInt(matcher.group(2))));
            }
        } else {
            dataType.setColumnSize(Integer.valueOf(Integer.parseInt(matcher.group(2))));
            dataType.setDecimalDigits(Integer.valueOf(Integer.parseInt(matcher.group(3))));
        }
        if ((extra = StringUtil.trimToNull((String)matcher.group(4))) != null && extra.equalsIgnoreCase("char")) {
            dataType.setColumnSizeUnit(DataType.ColumnSizeUnit.CHAR);
        }
        dataType.setDataTypeId(sqlTypeCode);
        return dataType;
    }
}

