/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event.spi;

import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.event.spi.BaseEnversUpdateEventListener;
import org.hibernate.envers.internal.synchronization.AuditProcess;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.event.spi.PreUpdateEventListener;

public class EnversPreUpdateEventListenerImpl
extends BaseEnversUpdateEventListener
implements PreUpdateEventListener {
    public EnversPreUpdateEventListenerImpl(EnversService enversService) {
        super(enversService);
    }

    @Override
    public boolean onPreUpdate(PreUpdateEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.getEnversService().getEntitiesConfigurations().isVersioned(entityName)) {
            this.checkIfTransactionInProgress(event.getSession());
            if (this.isDetachedEntityUpdate(entityName, event.getOldState())) {
                AuditProcess auditProcess = this.getEnversService().getAuditProcessManager().get(event.getSession());
                auditProcess.cacheEntityState(event.getId(), entityName, event.getPersister().getDatabaseSnapshot(event.getId(), event.getSession()));
            }
        }
        return false;
    }
}

