/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.synchronization;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SharedSessionContract;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoGenerator;
import org.hibernate.envers.internal.synchronization.EntityChangeNotifier;
import org.hibernate.envers.internal.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.tools.Pair;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.jboss.logging.Logger;

public class AuditProcess
implements BeforeTransactionCompletionProcess {
    private static final Logger log = Logger.getLogger(AuditProcess.class);
    private final RevisionInfoGenerator revisionInfoGenerator;
    private final SessionImplementor session;
    private final LinkedList<AuditWorkUnit> workUnits;
    private final Queue<AuditWorkUnit> undoQueue;
    private final Map<Pair<String, Object>, AuditWorkUnit> usedIds;
    private final Map<Pair<String, Object>, Object[]> entityStateCache;
    private final EntityChangeNotifier entityChangeNotifier;
    private Object revisionData;

    public AuditProcess(RevisionInfoGenerator revisionInfoGenerator, SessionImplementor session) {
        this.revisionInfoGenerator = revisionInfoGenerator;
        this.session = session;
        this.workUnits = new LinkedList();
        this.undoQueue = new LinkedList<AuditWorkUnit>();
        this.usedIds = new HashMap<Pair<String, Object>, AuditWorkUnit>();
        this.entityStateCache = new HashMap<Pair<String, Object>, Object[]>();
        this.entityChangeNotifier = new EntityChangeNotifier(revisionInfoGenerator, session);
    }

    public void cacheEntityState(Object id, String entityName, Object[] snapshot) {
        Pair<String, Object> key = new Pair<String, Object>(entityName, id);
        if (this.entityStateCache.containsKey(key)) {
            throw new AuditException("The entity [" + entityName + "] with id [" + id + "] is already cached.");
        }
        this.entityStateCache.put(key, snapshot);
    }

    public Object[] getCachedEntityState(Object id, String entityName) {
        Pair<String, Object> key = new Pair<String, Object>(entityName, id);
        Object[] entityState = this.entityStateCache.get(key);
        if (entityState != null) {
            this.entityStateCache.remove(key);
        }
        return entityState;
    }

    private void removeWorkUnit(AuditWorkUnit vwu) {
        this.workUnits.remove(vwu);
        if (vwu.isPerformed()) {
            this.undoQueue.offer(vwu);
        }
    }

    public void addWorkUnit(AuditWorkUnit vwu) {
        if (vwu.containsWork()) {
            Serializable entityId = vwu.getEntityId();
            if (entityId == null) {
                this.workUnits.offer(vwu);
            } else {
                String entityName = vwu.getEntityName();
                Pair<String, Serializable> usedIdsKey = Pair.make(entityName, entityId);
                if (this.usedIds.containsKey(usedIdsKey)) {
                    AuditWorkUnit other = this.usedIds.get(usedIdsKey);
                    AuditWorkUnit result = vwu.dispatch(other);
                    if (result != other) {
                        this.removeWorkUnit(other);
                        if (result != null) {
                            this.usedIds.put(usedIdsKey, result);
                            this.workUnits.offer(result);
                        }
                    }
                } else {
                    this.usedIds.put(usedIdsKey, vwu);
                    this.workUnits.offer(vwu);
                }
            }
        }
    }

    private void executeInSession(Session session) {
        AuditWorkUnit vwu;
        Object currentRevisionData = this.getCurrentRevisionData(session, true);
        while ((vwu = this.undoQueue.poll()) != null) {
            vwu.undo(session);
        }
        while ((vwu = this.workUnits.poll()) != null) {
            vwu.perform(session, this.revisionData);
            this.entityChangeNotifier.entityChanged(session, currentRevisionData, vwu);
        }
    }

    public Object getCurrentRevisionData(Session session, boolean persist) {
        if (this.revisionData == null) {
            this.revisionData = this.revisionInfoGenerator.generate();
        }
        if (!session.contains(this.revisionData) && persist) {
            this.revisionInfoGenerator.saveRevisionData(session, this.revisionData);
        }
        return this.revisionData;
    }

    @Override
    public void doBeforeTransactionCompletion(SessionImplementor session) {
        if (this.workUnits.size() == 0 && this.undoQueue.size() == 0) {
            return;
        }
        if (!session.getTransactionCoordinator().isActive()) {
            log.debug("Skipping envers transaction hook due to non-active (most likely marked-rollback-only) transaction");
            return;
        }
        if (FlushMode.MANUAL.equals((Object)session.getHibernateFlushMode()) || session.isClosed()) {
            try (SharedSessionContract temporarySession = null;){
                temporarySession = session.sessionWithOptions().connection().autoClose(false).connectionHandlingMode(PhysicalConnectionHandlingMode.DELAYED_ACQUISITION_AND_RELEASE_AFTER_TRANSACTION).noInterceptor().openSession();
                this.executeInSession((Session)temporarySession);
                temporarySession.flush();
            }
        } else {
            this.executeInSession(session);
            session.flush();
        }
    }
}

