/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.plugin.AbstractPluginFactory;

public class ExecutorService
extends AbstractPluginFactory<Executor> {
    private final Map<String, Executor> executors = new ConcurrentHashMap<String, Executor>();

    private ExecutorService() {
    }

    @Override
    protected Class<Executor> getPluginClass() {
        return Executor.class;
    }

    @Override
    protected int getPriority(Executor executor, Object ... args) {
        String name = (String)args[0];
        Database database = (Database)args[1];
        if (name.equals(executor.getName()) && executor.supports(database)) {
            return executor.getPriority();
        }
        return -1;
    }

    private String createKey(String executorName, Database database) {
        String key = executorName.toLowerCase() + "#" + System.identityHashCode(database);
        return key;
    }

    private Executor getExecutorValue(String executorName, Database database) throws UnexpectedLiquibaseException {
        String key = this.createKey(executorName, database);
        if (this.executors.containsKey(key)) {
            return this.executors.get(key);
        }
        Executor plugin = (Executor)this.getPlugin(executorName.toLowerCase(), database);
        try {
            return (Executor)plugin.getClass().newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public Executor getExecutor(String name, Database database) {
        Executor returnExecutor = this.executors.computeIfAbsent(this.createKey(name, database), db -> {
            try {
                Executor executor = this.getExecutorValue(name, database);
                executor.setDatabase(database);
                return executor;
            }
            catch (Exception e) {
                throw new UnexpectedLiquibaseException(e);
            }
        });
        return returnExecutor;
    }

    public boolean executorExists(String name, Database database) {
        return this.executors.containsKey(this.createKey(name, database));
    }

    public Executor getExecutor(Database database) {
        return this.getExecutor("jdbc", database);
    }

    public void setExecutor(Database database, Executor executor) {
        this.setExecutor("jdbc", database, executor);
    }

    public void setExecutor(String name, Database database, Executor executor) {
        this.executors.put(this.createKey(name, database), executor);
    }

    public void clearExecutor(Database database) {
        this.clearExecutor("jdbc", database);
    }

    public void clearExecutor(String name, Database database) {
        this.executors.remove(this.createKey(name, database));
    }

    public void reset() {
        this.executors.clear();
    }
}

