/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.formattedsql;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Labels;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.core.EmptyChange;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.parser.ChangeLogParser;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.precondition.core.SqlPrecondition;
import liquibase.resource.ResourceAccessor;
import liquibase.util.FileUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class FormattedSqlChangeLogParser
implements ChangeLogParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        BufferedReader reader = null;
        try {
            if (this.supportsExtension(changeLogFile)) {
                InputStream fileStream = this.openChangeLogFile(changeLogFile, resourceAccessor);
                if (fileStream == null) {
                    boolean bl = false;
                    return bl;
                }
                reader = new BufferedReader(StreamUtil.readStreamWithReader(fileStream, null));
                String firstLine = reader.readLine();
                while (firstLine.trim().isEmpty() && reader.ready()) {
                    firstLine = reader.readLine();
                }
                Pattern firstLinePattern = Pattern.compile("\\-\\-\\s*liquibase formatted.*", 2);
                boolean bl = firstLine != null && firstLinePattern.matcher(firstLine).matches();
                return bl;
            }
            boolean fileStream = false;
            return fileStream;
        }
        catch (IOException e) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Exception reading " + changeLogFile, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Scope.getCurrentScope().getLog(this.getClass()).fine("Exception closing " + changeLogFile, e);
                }
            }
        }
    }

    @Override
    public int getPriority() {
        return 6;
    }

    @Override
    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        DatabaseChangeLog changeLog = new DatabaseChangeLog();
        changeLog.setChangeLogParameters(changeLogParameters);
        changeLog.setPhysicalFilePath(physicalChangeLogLocation);
        try (BufferedReader reader = new BufferedReader(StreamUtil.readStreamWithReader(this.openChangeLogFile(physicalChangeLogLocation, resourceAccessor), null));){
            String line;
            StringBuilder currentSql = new StringBuilder();
            StringBuilder currentRollbackSql = new StringBuilder();
            ChangeSet changeSet = null;
            AbstractSQLChange change = null;
            Pattern changeLogPattern = Pattern.compile("\\-\\-\\s*liquibase formatted.*", 2);
            Pattern propertyPattern = Pattern.compile("\\s*\\-\\-[\\s]*property\\s+(.*:.*)\\s+(.*:.*).*", 2);
            Pattern altPropertyOneDashPattern = Pattern.compile("\\s*?[-]+\\s*property\\s.*", 2);
            Pattern changeSetPattern = Pattern.compile("\\s*\\-\\-[\\s]*changeset\\s+(\"[^\"]+\"|[^:]+):\\s*(\"[^\"]+\"|\\S+).*", 2);
            Pattern altChangeSetOneDashPattern = Pattern.compile("\\-[\\s]*changeset\\s.*", 2);
            Pattern altChangeSetNoOtherInfoPattern = Pattern.compile("\\s*\\-\\-[\\s]*changeset[\\s]*.*$", 2);
            Pattern rollbackPattern = Pattern.compile("\\s*\\-\\-[\\s]*rollback (.*)", 2);
            Pattern altRollbackOneDashPattern = Pattern.compile("\\s*\\-[\\s]*rollback\\s.*", 2);
            Pattern preconditionsPattern = Pattern.compile("\\s*\\-\\-[\\s]*preconditions(.*)", 2);
            Pattern altPreconditionsOneDashPattern = Pattern.compile("\\s*\\-[\\s]*preconditions\\s.*", 2);
            Pattern preconditionPattern = Pattern.compile("\\s*\\-\\-[\\s]*precondition\\-([a-zA-Z0-9-]+) (.*)", 2);
            Pattern altPreconditionOneDashPattern = Pattern.compile("\\s*\\-[\\s]*precondition(.*)", 2);
            Pattern stripCommentsPattern = Pattern.compile(".*stripComments:(\\w+).*", 2);
            Pattern splitStatementsPattern = Pattern.compile(".*splitStatements:(\\w+).*", 2);
            Pattern rollbackSplitStatementsPattern = Pattern.compile(".*rollbackSplitStatements:(\\w+).*", 2);
            Pattern endDelimiterPattern = Pattern.compile(".*endDelimiter:(\\S*).*", 2);
            Pattern rollbackEndDelimiterPattern = Pattern.compile(".*rollbackEndDelimiter:(\\S*).*", 2);
            Pattern commentPattern = Pattern.compile("\\-\\-[\\s]*comment:? (.*)", 2);
            Pattern altCommentPluralPattern = Pattern.compile("\\-\\-[\\s]*comments:? (.*)", 2);
            Pattern altCommentOneDashPattern = Pattern.compile("\\-[\\s]*comment:? (.*)", 2);
            Pattern validCheckSumPattern = Pattern.compile("\\-\\-[\\s]*validCheckSum:? (.*)", 2);
            Pattern altValidCheckSumOneDashPattern = Pattern.compile("^\\-[\\s]*validCheckSum(.*)$", 2);
            Pattern ignoreLinesPattern = Pattern.compile("\\-\\-[\\s]*ignoreLines:(\\w+)", 2);
            Pattern altIgnoreLinesOneDashPattern = Pattern.compile("\\-[\\s]*?ignoreLines:(\\w+).*$", 2);
            Pattern altIgnorePattern = Pattern.compile("\\-\\-[\\s]*ignore:(\\w+)", 2);
            Pattern runWithPattern = Pattern.compile(".*runWith:([\\w\\$\\{\\}]+).*", 2);
            Pattern runOnChangePattern = Pattern.compile(".*runOnChange:(\\w+).*", 2);
            Pattern runAlwaysPattern = Pattern.compile(".*runAlways:(\\w+).*", 2);
            Pattern contextPattern = Pattern.compile(".*context:(\".*\"|\\S*).*", 2);
            Pattern logicalFilePathPattern = Pattern.compile(".*logicalFilePath:(\\S*).*", 2);
            Pattern changeLogIdPattern = Pattern.compile(".*changeLogId:(\\S*).*", 2);
            Pattern labelsPattern = Pattern.compile(".*labels:(\\S*).*", 2);
            Pattern runInTransactionPattern = Pattern.compile(".*runInTransaction:(\\w+).*", 2);
            Pattern dbmsPattern = Pattern.compile(".*dbms:([^,][\\w!,]+).*", 2);
            Pattern failOnErrorPattern = Pattern.compile(".*failOnError:(\\w+).*", 2);
            Pattern onFailPattern = Pattern.compile(".*onFail:(\\w+).*", 2);
            Pattern onErrorPattern = Pattern.compile(".*onError:(\\w+).*", 2);
            Pattern onUpdateSqlPattern = Pattern.compile(".*onUpdateSQL:(\\w+).*", 2);
            Matcher rollbackSplitStatementsPatternMatcher = null;
            boolean rollbackSplitStatements = true;
            String rollbackEndDelimiter = null;
            int count = 0;
            block13: while ((line = reader.readLine()) != null) {
                String message;
                ++count;
                Matcher commentMatcher = commentPattern.matcher(line);
                Matcher propertyPatternMatcher = propertyPattern.matcher(line);
                Matcher altPropertyPatternMatcher = altPropertyOneDashPattern.matcher(line);
                if (propertyPatternMatcher.matches()) {
                    this.handleProperty(changeLogParameters, changeLog, propertyPatternMatcher);
                    continue;
                }
                if (altPropertyPatternMatcher.matches()) {
                    String message2 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--property name=<property name> value=<property value>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                    throw new ChangeLogParseException("\n" + message2);
                }
                Matcher changeLogPatterMatcher = changeLogPattern.matcher(line);
                if (changeLogPatterMatcher.matches()) {
                    Matcher logicalFilePathMatcher = logicalFilePathPattern.matcher(line);
                    changeLog.setLogicalFilePath(this.parseString(logicalFilePathMatcher));
                    Matcher changeLogIdMatcher = changeLogIdPattern.matcher(line);
                    changeLog.setChangeLogId(this.parseString(changeLogIdMatcher));
                }
                Matcher ignoreLinesMatcher = ignoreLinesPattern.matcher(line);
                Matcher altIgnoreMatcher = altIgnorePattern.matcher(line);
                Matcher altIgnoreLinesOneDashMatcher = altIgnoreLinesOneDashPattern.matcher(line);
                if (ignoreLinesMatcher.matches()) {
                    if ("start".equals(ignoreLinesMatcher.group(1))) {
                        while ((line = reader.readLine()) != null) {
                            altIgnoreLinesOneDashMatcher = altIgnoreLinesOneDashPattern.matcher(line);
                            ++count;
                            ignoreLinesMatcher = ignoreLinesPattern.matcher(line);
                            if (ignoreLinesMatcher.matches()) {
                                if (!"end".equals(ignoreLinesMatcher.group(1))) continue;
                                continue block13;
                            }
                            if (!altIgnoreLinesOneDashMatcher.matches()) continue;
                            String message3 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--ignoreLines:end' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                            throw new ChangeLogParseException("\n" + message3);
                        }
                        continue;
                    }
                    try {
                        long ignoreCount = Long.parseLong(ignoreLinesMatcher.group(1));
                        while (ignoreCount > 0L && (line = reader.readLine()) != null) {
                            --ignoreCount;
                            ++count;
                        }
                        continue;
                    }
                    catch (NullPointerException | NumberFormatException nfe) {
                        throw new ChangeLogParseException("Unknown ignoreLines syntax");
                    }
                }
                if (altIgnoreLinesOneDashMatcher.matches()) {
                    String message4 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--ignoreLines:<count|start>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                    throw new ChangeLogParseException("\n" + message4);
                }
                if (altIgnoreMatcher.matches()) {
                    String message5 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--ignoreLines:<count|start>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                    throw new ChangeLogParseException("\n" + message5);
                }
                Matcher changeSetPatternMatcher = changeSetPattern.matcher(line);
                if (changeSetPatternMatcher.matches()) {
                    String dbms;
                    String logicalFilePath;
                    String labels;
                    String finalCurrentSql = changeLogParameters.expandExpressions(StringUtil.trimToNull(currentSql.toString()), changeLog);
                    if (changeSet != null) {
                        if (finalCurrentSql == null) {
                            throw new ChangeLogParseException("No SQL for changeset " + changeSet.toString(false));
                        }
                        change.setSql(finalCurrentSql);
                        if (StringUtil.trimToNull(currentRollbackSql.toString()) != null) {
                            if (currentRollbackSql.toString().trim().toLowerCase().matches("^not required.*")) {
                                changeSet.addRollbackChange(new EmptyChange());
                            } else {
                                RawSQLChange rollbackChange = new RawSQLChange();
                                rollbackChange.setSql(changeLogParameters.expandExpressions(currentRollbackSql.toString(), changeLog));
                                if (rollbackSplitStatementsPatternMatcher.matches()) {
                                    rollbackChange.setSplitStatements(rollbackSplitStatements);
                                }
                                if (rollbackEndDelimiter != null) {
                                    rollbackChange.setEndDelimiter(rollbackEndDelimiter);
                                }
                                changeSet.addRollbackChange(rollbackChange);
                            }
                        }
                    }
                    Matcher stripCommentsPatternMatcher = stripCommentsPattern.matcher(line);
                    Matcher splitStatementsPatternMatcher = splitStatementsPattern.matcher(line);
                    Matcher runWithMatcher = runWithPattern.matcher(line);
                    rollbackSplitStatementsPatternMatcher = rollbackSplitStatementsPattern.matcher(line);
                    Matcher endDelimiterPatternMatcher = endDelimiterPattern.matcher(line);
                    Matcher rollbackEndDelimiterPatternMatcher = rollbackEndDelimiterPattern.matcher(line);
                    Matcher logicalFilePathMatcher = logicalFilePathPattern.matcher(line);
                    Matcher runOnChangePatternMatcher = runOnChangePattern.matcher(line);
                    Matcher runAlwaysPatternMatcher = runAlwaysPattern.matcher(line);
                    Matcher contextPatternMatcher = contextPattern.matcher(line);
                    Matcher labelsPatternMatcher = labelsPattern.matcher(line);
                    Matcher runInTransactionPatternMatcher = runInTransactionPattern.matcher(line);
                    Matcher dbmsPatternMatcher = dbmsPattern.matcher(line);
                    Matcher failOnErrorPatternMatcher = failOnErrorPattern.matcher(line);
                    boolean stripComments = this.parseBoolean(stripCommentsPatternMatcher, changeSet, true);
                    boolean splitStatements = this.parseBoolean(splitStatementsPatternMatcher, changeSet, true);
                    rollbackSplitStatements = this.parseBoolean(rollbackSplitStatementsPatternMatcher, changeSet, true);
                    boolean runOnChange = this.parseBoolean(runOnChangePatternMatcher, changeSet, false);
                    boolean runAlways = this.parseBoolean(runAlwaysPatternMatcher, changeSet, false);
                    boolean runInTransaction = this.parseBoolean(runInTransactionPatternMatcher, changeSet, true);
                    boolean failOnError = this.parseBoolean(failOnErrorPatternMatcher, changeSet, true);
                    String runWith = this.parseString(runWithMatcher);
                    if (runWith != null) {
                        runWith = changeLogParameters.expandExpressions(runWith, changeLog);
                    }
                    String endDelimiter = this.parseString(endDelimiterPatternMatcher);
                    rollbackEndDelimiter = this.parseString(rollbackEndDelimiterPatternMatcher);
                    String context = StringUtil.trimToNull(StringUtil.trimToEmpty(this.parseString(contextPatternMatcher)).replaceFirst("^\"", "").replaceFirst("\"$", ""));
                    if (context != null) {
                        context = changeLogParameters.expandExpressions(context, changeLog);
                    }
                    if ((labels = this.parseString(labelsPatternMatcher)) != null) {
                        labels = changeLogParameters.expandExpressions(labels, changeLog);
                    }
                    if ((logicalFilePath = this.parseString(logicalFilePathMatcher)) == null || "".equals(logicalFilePath)) {
                        logicalFilePath = changeLog.getLogicalFilePath();
                    }
                    if (logicalFilePath != null) {
                        logicalFilePath = changeLogParameters.expandExpressions(logicalFilePath, changeLog);
                    }
                    if ((dbms = this.parseString(dbmsPatternMatcher)) != null) {
                        dbms = changeLogParameters.expandExpressions(dbms, changeLog);
                    }
                    String idGroup = changeSetPatternMatcher.group(2);
                    String authorGroup = changeSetPatternMatcher.group(1);
                    Pattern changeSetAuthorIdPattern = Pattern.compile("\\s*\\-\\-[\\s]*changeset\\s+" + Pattern.quote(authorGroup + ":" + idGroup) + ".*$", 2);
                    Matcher changeSetAuthorIdPatternMatcher = changeSetAuthorIdPattern.matcher(line);
                    if (!changeSetAuthorIdPatternMatcher.matches()) {
                        String message6 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--changeset <authorname>:<changesetId>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                        throw new ChangeLogParseException("\n" + message6);
                    }
                    String changeSetId = changeLogParameters.expandExpressions(StringUtil.stripEnclosingQuotes(idGroup), changeLog);
                    String changeSetAuthor = changeLogParameters.expandExpressions(StringUtil.stripEnclosingQuotes(authorGroup), changeLog);
                    changeSet = new ChangeSet(changeSetId, changeSetAuthor, runAlways, runOnChange, logicalFilePath, context, dbms, runWith, runInTransaction, changeLog.getObjectQuotingStrategy(), changeLog);
                    changeSet.setLabels(new Labels(labels));
                    changeSet.setFailOnError(failOnError);
                    changeLog.addChangeSet(changeSet);
                    change = new RawSQLChange();
                    change.setSql(finalCurrentSql);
                    if (splitStatementsPatternMatcher.matches()) {
                        change.setSplitStatements(splitStatements);
                    }
                    change.setStripComments(stripComments);
                    change.setEndDelimiter(endDelimiter);
                    changeSet.addChange(change);
                    currentSql.setLength(0);
                    currentRollbackSql.setLength(0);
                    continue;
                }
                Matcher altChangeSetOneDashPatternMatcher = altChangeSetOneDashPattern.matcher(line);
                Matcher altChangeSetNoOtherInfoPatternMatcher = altChangeSetNoOtherInfoPattern.matcher(line);
                if (altChangeSetOneDashPatternMatcher.matches() || altChangeSetNoOtherInfoPatternMatcher.matches()) {
                    message = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--changeset <authorname>:<changesetId>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                    throw new ChangeLogParseException("\n" + message);
                }
                if (changeSet != null) {
                    String message7;
                    Matcher altCommentOneDashMatcher = altCommentOneDashPattern.matcher(line);
                    Matcher altCommentPluralMatcher = altCommentPluralPattern.matcher(line);
                    Matcher rollbackMatcher = rollbackPattern.matcher(line);
                    Matcher altRollbackMatcher = altRollbackOneDashPattern.matcher(line);
                    Matcher preconditionsMatcher = preconditionsPattern.matcher(line);
                    Matcher altPreconditionsOneDashMatcher = altPreconditionsOneDashPattern.matcher(line);
                    Matcher preconditionMatcher = preconditionPattern.matcher(line);
                    Matcher altPreconditionOneDashMatcher = altPreconditionOneDashPattern.matcher(line);
                    Matcher validCheckSumMatcher = validCheckSumPattern.matcher(line);
                    Matcher altValidCheckSumOneDashMatcher = altValidCheckSumOneDashPattern.matcher(line);
                    if (commentMatcher.matches()) {
                        if (commentMatcher.groupCount() == 0) {
                            message7 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--comment <comment>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                            throw new ChangeLogParseException("\n" + message7);
                        }
                        if (commentMatcher.groupCount() != 1) continue;
                        changeSet.setComments(commentMatcher.group(1));
                        continue;
                    }
                    if (altCommentOneDashMatcher.matches() || altCommentPluralMatcher.matches()) {
                        message7 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--comment <comment>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                        throw new ChangeLogParseException("\n" + message7);
                    }
                    if (validCheckSumMatcher.matches()) {
                        if (validCheckSumMatcher.groupCount() == 0) {
                            message7 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--rollback <rollback SQL>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                            throw new ChangeLogParseException("\n" + message7);
                        }
                        if (validCheckSumMatcher.groupCount() != 1) continue;
                        changeSet.addValidCheckSum(validCheckSumMatcher.group(1));
                        continue;
                    }
                    if (altValidCheckSumOneDashMatcher.matches()) {
                        message7 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--validChecksum <checksum>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                        throw new ChangeLogParseException("\n" + message7);
                    }
                    if (rollbackMatcher.matches()) {
                        if (rollbackMatcher.groupCount() == 0) {
                            message7 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--rollback <rollback SQL>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                            throw new ChangeLogParseException("\n" + message7);
                        }
                        currentRollbackSql.append(rollbackMatcher.group(1)).append(System.lineSeparator());
                        continue;
                    }
                    if (altRollbackMatcher.matches()) {
                        message7 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--rollback <rollback SQL>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                        throw new ChangeLogParseException("\n" + message7);
                    }
                    if (preconditionsMatcher.matches()) {
                        if (preconditionsMatcher.groupCount() == 0) {
                            message7 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--preconditions <onFail>|<onError>|<onUpdate>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                            throw new ChangeLogParseException("\n" + message7);
                        }
                        if (preconditionsMatcher.groupCount() != 1) continue;
                        String body = preconditionsMatcher.group(1);
                        Matcher onFailMatcher = onFailPattern.matcher(body);
                        Matcher onErrorMatcher = onErrorPattern.matcher(body);
                        Matcher onUpdateSqlMatcher = onUpdateSqlPattern.matcher(body);
                        PreconditionContainer pc = new PreconditionContainer();
                        pc.setOnFail(StringUtil.trimToNull(this.parseString(onFailMatcher)));
                        pc.setOnError(StringUtil.trimToNull(this.parseString(onErrorMatcher)));
                        pc.setOnSqlOutput(StringUtil.trimToNull(this.parseString(onUpdateSqlMatcher)));
                        changeSet.setPreconditions(pc);
                        continue;
                    }
                    if (altPreconditionsOneDashMatcher.matches()) {
                        message7 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--preconditions <onFail>|<onError>|<onUpdate>' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                        throw new ChangeLogParseException("\n" + message7);
                    }
                    if (preconditionMatcher.matches()) {
                        String name;
                        if (changeSet.getPreconditions() == null) {
                            changeSet.setPreconditions(new PreconditionContainer());
                        }
                        if (preconditionMatcher.groupCount() != 2 || (name = StringUtil.trimToNull(preconditionMatcher.group(1))) == null) continue;
                        String body = preconditionMatcher.group(2).trim();
                        if ("sql-check".equals(name)) {
                            changeSet.getPreconditions().addNestedPrecondition(this.parseSqlCheckCondition(changeLogParameters.expandExpressions(StringUtil.trimToNull(body), changeSet.getChangeLog())));
                            continue;
                        }
                        throw new ChangeLogParseException("The '" + name + "' precondition type is not supported.");
                    }
                    if (altPreconditionOneDashMatcher.matches()) {
                        message7 = String.format("Unexpected formatting at line %d. Formatted SQL changelogs require known formats, such as '--precondition-sql-check' and others to be recognized and run. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                        throw new ChangeLogParseException("\n" + message7);
                    }
                    currentSql.append(line).append(System.lineSeparator());
                    continue;
                }
                if (!commentMatcher.matches()) continue;
                message = String.format("Unexpected formatting at line %d. Formatted SQL changelogs do not allow comment lines outside of changesets. Learn all the options at https://docs.liquibase.com/concepts/changelogs/sql-format.html", count);
                throw new ChangeLogParseException("\n" + message);
            }
            if (changeSet != null) {
                change.setSql(changeLogParameters.expandExpressions(StringUtil.trimToNull(currentSql.toString()), changeSet.getChangeLog()));
                if (change.getEndDelimiter() == null && StringUtil.trimToEmpty(((RawSQLChange)change).getSql()).endsWith("\n/")) {
                    change.setEndDelimiter("\n/$");
                }
                if (StringUtil.trimToNull(currentRollbackSql.toString()) != null) {
                    if (currentRollbackSql.toString().trim().toLowerCase().matches("^not required.*")) {
                        changeSet.addRollbackChange(new EmptyChange());
                    } else {
                        RawSQLChange rollbackChange = new RawSQLChange();
                        rollbackChange.setSql(changeLogParameters.expandExpressions(currentRollbackSql.toString(), changeSet.getChangeLog()));
                        if (rollbackSplitStatementsPatternMatcher.matches()) {
                            rollbackChange.setSplitStatements(rollbackSplitStatements);
                        }
                        if (rollbackEndDelimiter != null) {
                            rollbackChange.setEndDelimiter(rollbackEndDelimiter);
                        }
                        changeSet.addRollbackChange(rollbackChange);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ChangeLogParseException(e);
        }
        return changeLog;
    }

    private void handleProperty(ChangeLogParameters changeLogParameters, DatabaseChangeLog changeLog, Matcher propertyPatternMatcher) {
        String name = null;
        String value = null;
        String context = null;
        String labels = null;
        String dbms = null;
        boolean global = true;
        block16: for (int i = 1; i <= propertyPatternMatcher.groupCount(); ++i) {
            String key;
            String temp = propertyPatternMatcher.group(i);
            String[] parts = temp.split(":");
            switch (key = parts[0].trim().toLowerCase()) {
                case "name": {
                    name = parts[1].trim();
                    continue block16;
                }
                case "value": {
                    value = parts[1].trim();
                    continue block16;
                }
                case "context": {
                    context = parts[1].trim();
                    continue block16;
                }
                case "labels": {
                    labels = parts[1].trim();
                    continue block16;
                }
                case "dbms": {
                    dbms = parts[1].trim();
                    continue block16;
                }
                case "global": {
                    global = Boolean.parseBoolean(parts[1].trim());
                }
            }
        }
        changeLogParameters.set(name, value, context, labels, dbms, global, changeLog);
    }

    protected boolean supportsExtension(String changelogFile) {
        return changelogFile.toLowerCase().endsWith(".sql");
    }

    private SqlPrecondition parseSqlCheckCondition(String body) throws ChangeLogParseException {
        Pattern[] patterns;
        for (Pattern pattern : patterns = new Pattern[]{Pattern.compile("^(?:expectedResult:)?(\\w+) (.*)", 2), Pattern.compile("^(?:expectedResult:)?'([^']+)' (.*)", 2), Pattern.compile("^(?:expectedResult:)?\"([^\"]+)\" (.*)", 2)}) {
            Matcher matcher = pattern.matcher(body);
            if (!matcher.matches() || matcher.groupCount() != 2) continue;
            SqlPrecondition p = new SqlPrecondition();
            p.setExpectedResult(matcher.group(1));
            p.setSql(matcher.group(2));
            return p;
        }
        throw new ChangeLogParseException("Could not parse a SqlCheck precondition from '" + body + "'.");
    }

    private String parseString(Matcher matcher) {
        String endDelimiter = null;
        if (matcher.matches()) {
            endDelimiter = matcher.group(1);
        }
        return endDelimiter;
    }

    private boolean parseBoolean(Matcher matcher, ChangeSet changeSet, boolean defaultValue) throws ChangeLogParseException {
        boolean stripComments = defaultValue;
        if (matcher.matches()) {
            try {
                stripComments = Boolean.parseBoolean(matcher.group(1));
            }
            catch (Exception e) {
                throw new ChangeLogParseException("Cannot parse " + changeSet + " " + matcher.toString().replaceAll("\\.*", "") + " as a boolean");
            }
        }
        return stripComments;
    }

    protected InputStream openChangeLogFile(String physicalChangeLogLocation, ResourceAccessor resourceAccessor) throws IOException {
        InputStream resourceAsStream = resourceAccessor.openStream(null, physicalChangeLogLocation);
        if (resourceAsStream == null) {
            File physicalChangeLogFile = new File(physicalChangeLogLocation);
            throw new IOException(FileUtil.getFileNotFoundMessage(physicalChangeLogFile.getAbsolutePath()));
        }
        return resourceAsStream;
    }
}

