/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap;

import java.beans.Introspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.ElementKindVisitor6;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.mapstruct.ap.MapperPrism;
import org.mapstruct.ap.MappingPrism;
import org.mapstruct.ap.MappingsPrism;
import org.mapstruct.ap.conversion.Conversion;
import org.mapstruct.ap.conversion.Conversions;
import org.mapstruct.ap.model.BeanMapping;
import org.mapstruct.ap.model.Mapper;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.Options;
import org.mapstruct.ap.model.PropertyMapping;
import org.mapstruct.ap.model.Type;
import org.mapstruct.ap.model.source.MappedProperty;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.model.source.Parameter;
import org.mapstruct.ap.util.Executables;
import org.mapstruct.ap.util.Filters;
import org.mapstruct.ap.util.TypeUtil;
import org.mapstruct.ap.writer.ModelWriter;

public class MapperGenerationVisitor
extends ElementKindVisitor6<Void, Void> {
    private static final String IMPLEMENTATION_SUFFIX = "Impl";
    private final ProcessingEnvironment processingEnvironment;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final TypeUtil typeUtil;
    private final Options options;
    private boolean mappingErroneous = false;

    public MapperGenerationVisitor(ProcessingEnvironment processingEnvironment, Options options) {
        this.processingEnvironment = processingEnvironment;
        this.typeUtils = processingEnvironment.getTypeUtils();
        this.elementUtils = processingEnvironment.getElementUtils();
        this.typeUtil = new TypeUtil(this.elementUtils, this.typeUtils);
        this.options = options;
    }

    @Override
    public Void visitTypeAsInterface(TypeElement element, Void p) {
        Mapper model = this.retrieveModel(element);
        if (!this.mappingErroneous) {
            String sourceFileName = element.getQualifiedName() + IMPLEMENTATION_SUFFIX;
            this.writeModelToSourceFile(sourceFileName, model);
        }
        return null;
    }

    private void writeModelToSourceFile(String fileName, Mapper model) {
        JavaFileObject sourceFile;
        try {
            sourceFile = this.processingEnvironment.getFiler().createSourceFile(fileName, new Element[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ModelWriter modelWriter = new ModelWriter("mapper-implementation.ftl");
        modelWriter.writeModel(sourceFile, model);
    }

    private Mapper retrieveModel(TypeElement element) {
        List<Method> methods = this.retrieveMethods(null, element);
        List<BeanMapping> mappings = this.getMappings(methods);
        List<Type> usedMapperTypes = this.getUsedMapperTypes(element);
        Mapper mapper = new Mapper(this.elementUtils.getPackageOf(element).getQualifiedName().toString(), element.getSimpleName().toString(), element.getSimpleName() + IMPLEMENTATION_SUFFIX, mappings, usedMapperTypes, this.options);
        return mapper;
    }

    private List<BeanMapping> getMappings(List<Method> methods) {
        Conversions conversions = new Conversions(this.elementUtils, this.typeUtils, this.typeUtil);
        ArrayList<BeanMapping> mappings = new ArrayList<BeanMapping>();
        HashSet<Method> processedMethods = new HashSet<Method>();
        for (Method method : methods) {
            if (processedMethods.contains(method)) continue;
            MappingMethod mappingMethod = new MappingMethod(method.getDeclaringMapper(), method.getName(), method.getParameterName(), this.getElementMappingMethod(methods, method));
            MappingMethod reverseMappingMethod = null;
            Method rawReverseMappingMethod = this.getReverseMappingMethod(methods, method);
            if (rawReverseMappingMethod != null) {
                processedMethods.add(rawReverseMappingMethod);
                reverseMappingMethod = new MappingMethod(rawReverseMappingMethod.getDeclaringMapper(), rawReverseMappingMethod.getName(), rawReverseMappingMethod.getParameterName(), this.getElementMappingMethod(methods, rawReverseMappingMethod));
            }
            ArrayList<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();
            for (MappedProperty property : method.getMappedProperties()) {
                Method propertyMappingMethod = this.getPropertyMappingMethod(methods, property);
                Method reversePropertyMappingMethod = this.getReversePropertyMappingMethod(methods, property);
                Conversion conversion = conversions.getConversion(property.getSourceType(), property.getTargetType());
                this.reportErrorIfPropertyCanNotBeMapped(method, rawReverseMappingMethod, property, propertyMappingMethod, reversePropertyMappingMethod, conversion);
                propertyMappings.add(new PropertyMapping(property.getSourceReadAccessorName(), property.getSourceWriteAccessorName(), property.getSourceType(), property.getTargetReadAccessorName(), property.getTargetWriteAccessorName(), property.getTargetType(), propertyMappingMethod != null ? new MappingMethod(propertyMappingMethod.getDeclaringMapper(), propertyMappingMethod.getName(), propertyMappingMethod.getParameterName()) : null, reversePropertyMappingMethod != null ? new MappingMethod(reversePropertyMappingMethod.getDeclaringMapper(), reversePropertyMappingMethod.getName(), reversePropertyMappingMethod.getParameterName()) : null, conversion != null ? conversion.to(mappingMethod.getParameterName() + "." + property.getSourceReadAccessorName() + "()", property.getTargetType()) : null, conversion != null && reverseMappingMethod != null ? conversion.from(reverseMappingMethod.getParameterName() + "." + property.getTargetReadAccessorName() + "()", property.getSourceType()) : null));
            }
            boolean isIterableMapping = method.getSourceType().isIterableType() && method.getTargetType().isIterableType();
            String toConversionString = null;
            String fromConversionString = null;
            if (isIterableMapping) {
                toConversionString = this.getIterableConversionString(conversions, method.getSourceType().getElementType(), method.getTargetType().getElementType(), true);
                fromConversionString = this.getIterableConversionString(conversions, method.getTargetType().getElementType(), method.getSourceType().getElementType(), false);
            }
            BeanMapping mapping = new BeanMapping(method.getSourceType(), method.getTargetType(), propertyMappings, mappingMethod, reverseMappingMethod, toConversionString, fromConversionString);
            mappings.add(mapping);
        }
        return mappings;
    }

    private void reportErrorIfPropertyCanNotBeMapped(Method method, Method reverseMethod, MappedProperty property, Method propertyMappingMethod, Method reversePropertyMappingMethod, Conversion conversion) {
        if (property.getSourceType().equals(property.getTargetType())) {
            return;
        }
        if (!(propertyMappingMethod != null || conversion != null || property.getTargetType().isCollectionType() && property.getTargetType().getCollectionImplementationType() != null)) {
            this.reportError(String.format("Can't map property \"%s %s\" to \"%s %s\".", property.getSourceType(), property.getSourceName(), property.getTargetType(), property.getTargetName()), method.getExecutable());
        }
        if (reverseMethod == null) {
            return;
        }
        if (!(reversePropertyMappingMethod != null || conversion != null || property.getSourceType().isCollectionType() && property.getSourceType().getCollectionImplementationType() != null)) {
            this.reportError(String.format("Can't map property \"%s %s\" to \"%s %s\".", property.getTargetType(), property.getTargetName(), property.getSourceType(), property.getSourceName()), reverseMethod.getExecutable());
        }
    }

    private String getIterableConversionString(Conversions conversions, Type sourceElementType, Type targetElementType, boolean isToConversion) {
        Conversion conversion = conversions.getConversion(sourceElementType, targetElementType);
        if (conversion == null) {
            return null;
        }
        return conversion.to(Introspector.decapitalize(sourceElementType.getName()), targetElementType);
    }

    private List<Type> getUsedMapperTypes(TypeElement element) {
        LinkedList<Type> usedMapperTypes = new LinkedList<Type>();
        MapperPrism mapperPrism = MapperPrism.getInstanceOn(element);
        for (TypeMirror usedMapper : mapperPrism.uses()) {
            usedMapperTypes.add(this.typeUtil.retrieveType(usedMapper));
        }
        return usedMapperTypes;
    }

    private MappingMethod getElementMappingMethod(Iterable<Method> methods, Method method) {
        Method elementMappingMethod = null;
        for (Method oneMethod : methods) {
            if (!oneMethod.getSourceType().equals(method.getSourceType().getElementType())) continue;
            elementMappingMethod = oneMethod;
            break;
        }
        return elementMappingMethod == null ? null : new MappingMethod(elementMappingMethod.getDeclaringMapper(), elementMappingMethod.getName(), elementMappingMethod.getParameterName());
    }

    private Method getPropertyMappingMethod(Iterable<Method> rawMethods, MappedProperty property) {
        for (Method oneMethod : rawMethods) {
            if (!oneMethod.getSourceType().equals(property.getSourceType()) || !oneMethod.getTargetType().equals(property.getTargetType())) continue;
            return oneMethod;
        }
        return null;
    }

    private Method getReversePropertyMappingMethod(Iterable<Method> methods, MappedProperty property) {
        for (Method method : methods) {
            if (!method.getSourceType().equals(property.getTargetType()) || !method.getTargetType().equals(property.getSourceType())) continue;
            return method;
        }
        return null;
    }

    private Method getReverseMappingMethod(List<Method> rawMethods, Method method) {
        for (Method oneMethod : rawMethods) {
            if (!oneMethod.reverses(method)) continue;
            return oneMethod;
        }
        return null;
    }

    private List<Method> retrieveMethods(Type declaringMapper, Element element) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (ExecutableElement method : ElementFilter.methodsIn(element.getEnclosedElements())) {
            Parameter parameter = this.retrieveParameter(method);
            Type returnType = this.retrieveReturnType(method);
            boolean mappingErroneous = false;
            if (declaringMapper == null) {
                if (parameter.getType().isIterableType() && !returnType.isIterableType()) {
                    this.reportError("Can't generate mapping method from iterable type to non-iterable ype.", method);
                    mappingErroneous = true;
                }
                if (!parameter.getType().isIterableType() && returnType.isIterableType()) {
                    this.reportError("Can't generate mapping method from non-iterable type to iterable ype.", method);
                    mappingErroneous = true;
                }
                if (parameter.getType().isPrimitive()) {
                    this.reportError("Can't generate mapping method with primitive parameter type.", method);
                    mappingErroneous = true;
                }
                if (returnType.isPrimitive()) {
                    this.reportError("Can't generate mapping method with primitive return type.", method);
                    mappingErroneous = true;
                }
                if (mappingErroneous) continue;
            }
            List<MappedProperty> properties = declaringMapper == null ? this.retrieveMappedProperties(method) : Collections.emptyList();
            methods.add(new Method(declaringMapper, method, parameter.getName(), parameter.getType(), returnType, properties));
        }
        MapperPrism mapperPrism = MapperPrism.getInstanceOn(element);
        if (mapperPrism != null) {
            for (TypeMirror usedMapper : mapperPrism.uses()) {
                methods.addAll(this.retrieveMethods(this.typeUtil.retrieveType(usedMapper), ((DeclaredType)usedMapper).asElement()));
            }
        }
        return methods;
    }

    private List<MappedProperty> retrieveMappedProperties(ExecutableElement method) {
        HashMap<String, Mapping> mappings = new HashMap<String, Mapping>();
        MappingPrism mappingAnnotation = MappingPrism.getInstanceOn(method);
        MappingsPrism mappingsAnnotation = MappingsPrism.getInstanceOn(method);
        if (mappingAnnotation != null) {
            mappings.put(mappingAnnotation.source(), this.getMapping(mappingAnnotation));
        }
        if (mappingsAnnotation != null) {
            mappings.putAll(this.getMappings(mappingsAnnotation));
        }
        return this.getMappedProperties(method, mappings);
    }

    private List<MappedProperty> getMappedProperties(ExecutableElement method, Map<String, Mapping> mappings) {
        Element returnTypeElement = this.typeUtils.asElement(method.getReturnType());
        Element parameterElement = this.typeUtils.asElement(method.getParameters().get(0).asType());
        ArrayList<MappedProperty> properties = new ArrayList<MappedProperty>();
        List<ExecutableElement> sourceGetters = Filters.getterMethodsIn(parameterElement.getEnclosedElements());
        List<ExecutableElement> targetSetters = Filters.setterMethodsIn(returnTypeElement.getEnclosedElements());
        this.reportErrorIfMappedPropertiesDontExist(method, mappings, sourceGetters, targetSetters);
        for (ExecutableElement getterMethod : sourceGetters) {
            String sourcePropertyName = Executables.getPropertyName(getterMethod);
            Mapping mapping = mappings.get(sourcePropertyName);
            for (ExecutableElement setterMethod : targetSetters) {
                String targetPropertyName = Executables.getPropertyName(setterMethod);
                if (!targetPropertyName.equals(mapping != null ? mapping.getTargetName() : sourcePropertyName)) continue;
                properties.add(new MappedProperty(sourcePropertyName, getterMethod.getSimpleName().toString(), Executables.getCorrespondingSetterMethod(parameterElement, getterMethod).getSimpleName().toString(), this.retrieveReturnType(getterMethod), mapping != null ? mapping.getTargetName() : targetPropertyName, Executables.getCorrespondingGetterMethod(returnTypeElement, setterMethod).getSimpleName().toString(), setterMethod.getSimpleName().toString(), this.retrieveParameter(setterMethod).getType()));
            }
        }
        return properties;
    }

    private void reportErrorIfMappedPropertiesDontExist(ExecutableElement method, Map<String, Mapping> mappings, List<ExecutableElement> sourceGetters, List<ExecutableElement> targetSetters) {
        Set<String> sourcePropertyNames = this.getPropertyNames(sourceGetters);
        Set<String> targetPropertyNames = this.getPropertyNames(targetSetters);
        for (Mapping mappedProperty : mappings.values()) {
            if (!sourcePropertyNames.contains(mappedProperty.getSourceName())) {
                this.reportError(String.format("Unknown property \"%s\" in parameter type %s.", mappedProperty.getSourceName(), this.retrieveParameter(method).getType()), method, mappedProperty.getMirror(), mappedProperty.getSourceAnnotationValue());
            }
            if (targetPropertyNames.contains(mappedProperty.getTargetName())) continue;
            this.reportError(String.format("Unknown property \"%s\" in return type %s.", mappedProperty.getTargetName(), this.retrieveReturnType(method)), method, mappedProperty.getMirror(), mappedProperty.getTargetAnnotationValue());
        }
    }

    private Set<String> getPropertyNames(List<ExecutableElement> propertyAccessors) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (ExecutableElement executableElement : propertyAccessors) {
            propertyNames.add(Executables.getPropertyName(executableElement));
        }
        return propertyNames;
    }

    private Map<String, Mapping> getMappings(MappingsPrism mappingsAnnotation) {
        HashMap<String, Mapping> mappings = new HashMap<String, Mapping>();
        for (MappingPrism mapping : mappingsAnnotation.value()) {
            mappings.put(mapping.source(), this.getMapping(mapping));
        }
        return mappings;
    }

    private Mapping getMapping(MappingPrism mapping) {
        return new Mapping(mapping.source(), mapping.target(), mapping.mirror, mapping.values.source(), mapping.values.target());
    }

    private Parameter retrieveParameter(ExecutableElement method) {
        List<? extends VariableElement> parameters = method.getParameters();
        if (parameters.size() != 1) {
            return null;
        }
        VariableElement parameter = parameters.get(0);
        return new Parameter(parameter.getSimpleName().toString(), this.typeUtil.retrieveType(parameter.asType()));
    }

    private Type retrieveReturnType(ExecutableElement method) {
        return this.typeUtil.retrieveType(method.getReturnType());
    }

    private void reportError(String message, Element element) {
        this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
        this.mappingErroneous = true;
    }

    private void reportError(String message, Element element, AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
        this.processingEnvironment.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element, annotationMirror, annotationValue);
        this.mappingErroneous = true;
    }
}

