/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import org.mapstruct.ap.conversion.Conversion;
import org.mapstruct.ap.model.Type;
import org.mapstruct.ap.util.NativeTypes;
import org.mapstruct.ap.util.Strings;

public class PrimitiveToStringConversion
implements Conversion {
    private final Class<?> sourceType;
    private final Class<?> wrapperType;

    public PrimitiveToStringConversion(Class<?> sourceType) {
        if (!sourceType.isPrimitive()) {
            throw new IllegalArgumentException(sourceType + " is no primitive type.");
        }
        this.sourceType = sourceType;
        this.wrapperType = NativeTypes.getWrapperType(sourceType);
    }

    @Override
    public String to(String sourcePropertyAccessor, Type type) {
        return "String.valueOf( " + sourcePropertyAccessor + " )";
    }

    @Override
    public String from(String targetPropertyAccessor, Type type) {
        return this.wrapperType.getSimpleName() + ".parse" + Strings.capitalize(this.sourceType.getSimpleName()) + "( " + targetPropertyAccessor + " )";
    }
}

