/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.List;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.PropertyMapping;
import org.mapstruct.ap.model.Type;

public class BeanMapping {
    private final Type sourceType;
    private final Type targetType;
    private final List<PropertyMapping> propertyMappings;
    private final MappingMethod mappingMethod;
    private final MappingMethod reverseMappingMethod;
    private final boolean isIterableMapping;
    private final String toConversion;
    private final String fromConversion;

    public BeanMapping(Type sourceType, Type targetType, List<PropertyMapping> propertyMappings, MappingMethod mappingMethod, MappingMethod reverseMappingMethod, String toConversion, String fromConversion) {
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.propertyMappings = propertyMappings;
        this.mappingMethod = mappingMethod;
        this.reverseMappingMethod = reverseMappingMethod;
        this.isIterableMapping = sourceType.isIterableType() && targetType.isIterableType();
        this.toConversion = toConversion;
        this.fromConversion = fromConversion;
    }

    public Type getSourceType() {
        return this.sourceType;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public List<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings;
    }

    public MappingMethod getMappingMethod() {
        return this.mappingMethod;
    }

    public MappingMethod getReverseMappingMethod() {
        return this.reverseMappingMethod;
    }

    public boolean isIterableMapping() {
        return this.isIterableMapping;
    }

    public String getToConversion() {
        return this.toConversion;
    }

    public String getFromConversion() {
        return this.fromConversion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BeanMapping {");
        sb.append("\n    sourceType=" + this.sourceType + ',');
        sb.append("\n    targetType=" + this.targetType + ',');
        sb.append("\n    propertyMappings=[\n");
        for (PropertyMapping propertyMapping : this.propertyMappings) {
            sb.append("        " + propertyMapping.toString().replaceAll("\n", "\n        "));
        }
        sb.append("\n    ]");
        sb.append("\n    mappingMethod=" + this.mappingMethod.toString().replaceAll("\n", "\n    ") + ',');
        sb.append("\n    reverseMappingMethod=" + this.reverseMappingMethod + ',');
        sb.append("\n    toConversion=" + this.toConversion + ',');
        sb.append("\n    fromConversion=" + this.fromConversion + ',');
        sb.append("\n    isIterableMapping=" + this.isIterableMapping);
        sb.append("\n}");
        return sb.toString();
    }
}

