/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Type
implements Comparable<Type> {
    private static final Set<String> PRIMITIVE_TYPE_NAMES = new HashSet<String>(Arrays.asList("boolean", "char", "byte", "short", "int", "long", "float", "double"));
    private static final ConcurrentMap<String, Type> DEFAULT_ITERABLE_IMPLEMENTATION_TYPES = new ConcurrentHashMap<String, Type>();
    private static final ConcurrentMap<String, Type> DEFAULT_COLLECTION_IMPLEMENTATION_TYPES = new ConcurrentHashMap<String, Type>();
    private final String packageName;
    private final String name;
    private final Type elementType;
    private final boolean isEnumType;
    private final boolean isCollectionType;
    private final boolean isIterableType;
    private final Type collectionImplementationType;
    private final Type iterableImplementationType;

    public static Type forClass(Class<?> clazz) {
        Package pakkage = clazz.getPackage();
        if (pakkage != null) {
            return new Type(pakkage.getName(), clazz.getSimpleName(), null, clazz.isEnum(), Collection.class.isAssignableFrom(clazz), Iterable.class.isAssignableFrom(clazz));
        }
        return new Type(clazz.getSimpleName());
    }

    public Type(String name) {
        this(null, name, null, false, false, false);
    }

    public Type(String packageName, String name, Type elementType, boolean isEnumType, boolean isCollectionType, boolean isIterableType) {
        this.packageName = packageName;
        this.name = name;
        this.elementType = elementType;
        this.isEnumType = isEnumType;
        this.isCollectionType = isCollectionType;
        this.isIterableType = isIterableType;
        this.collectionImplementationType = isCollectionType ? (Type)DEFAULT_COLLECTION_IMPLEMENTATION_TYPES.get(packageName + "." + name) : null;
        this.iterableImplementationType = isIterableType ? (Type)DEFAULT_ITERABLE_IMPLEMENTATION_TYPES.get(packageName + "." + name) : null;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public boolean isPrimitive() {
        return this.packageName == null && PRIMITIVE_TYPE_NAMES.contains(this.name);
    }

    public boolean isEnumType() {
        return this.isEnumType;
    }

    public Type getCollectionImplementationType() {
        return this.collectionImplementationType;
    }

    public Type getIterableImplementationType() {
        return this.iterableImplementationType;
    }

    public boolean isCollectionType() {
        return this.isCollectionType;
    }

    public boolean isIterableType() {
        return this.isIterableType;
    }

    public String getFullyQualifiedName() {
        return this.packageName == null ? this.name : this.packageName + "." + this.name;
    }

    public String toString() {
        if (this.packageName == null) {
            return this.name;
        }
        if (this.elementType == null) {
            return this.packageName + "." + this.name;
        }
        return this.packageName + "." + this.name + "<" + this.elementType + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        if (this.elementType == null ? other.elementType != null : !this.elementType.equals(other.elementType)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
    }

    @Override
    public int compareTo(Type o) {
        return this.getFullyQualifiedName().compareTo(o.getFullyQualifiedName());
    }

    static {
        DEFAULT_COLLECTION_IMPLEMENTATION_TYPES.put(List.class.getName(), Type.forClass(ArrayList.class));
        DEFAULT_COLLECTION_IMPLEMENTATION_TYPES.put(Set.class.getName(), Type.forClass(HashSet.class));
        DEFAULT_COLLECTION_IMPLEMENTATION_TYPES.put(Collection.class.getName(), Type.forClass(ArrayList.class));
        DEFAULT_ITERABLE_IMPLEMENTATION_TYPES.put(Iterable.class.getName(), Type.forClass(ArrayList.class));
        DEFAULT_ITERABLE_IMPLEMENTATION_TYPES.putAll(DEFAULT_COLLECTION_IMPLEMENTATION_TYPES);
    }
}

