/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.model.Type;
import org.mapstruct.ap.model.source.MappedProperty;

public class Method {
    private final Type declaringMapper;
    private final ExecutableElement executable;
    private final String parameterName;
    private final Type sourceType;
    private final Type targetType;
    private final List<MappedProperty> mappedProperties;

    public Method(Type declaringMapper, ExecutableElement executable, String parameterName, Type sourceType, Type targetType, List<MappedProperty> mappedProperties) {
        this.declaringMapper = declaringMapper;
        this.executable = executable;
        this.parameterName = parameterName;
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.mappedProperties = mappedProperties;
    }

    public Type getDeclaringMapper() {
        return this.declaringMapper;
    }

    public ExecutableElement getExecutable() {
        return this.executable;
    }

    public String getName() {
        return this.executable.getSimpleName().toString();
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public Type getSourceType() {
        return this.sourceType;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public List<MappedProperty> getMappedProperties() {
        return this.mappedProperties;
    }

    public boolean reverses(Method method) {
        return this.equals(this.sourceType, method.getTargetType()) && this.equals(this.targetType, method.getSourceType());
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public String toString() {
        return this.targetType + " " + this.getName() + "(" + this.sourceType + " " + this.parameterName + ")";
    }
}

