/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.util;

import java.beans.Introspector;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.mapstruct.ap.util.Filters;

public class Executables {
    private Executables() {
    }

    public static boolean isGetterMethod(ExecutableElement method) {
        return Executables.isNonBooleanGetterMethod(method) || Executables.isBooleanGetterMethod(method);
    }

    private static boolean isNonBooleanGetterMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return method.getParameters().isEmpty() && name.startsWith("get") && name.length() > 3 && method.getReturnType().getKind() != TypeKind.VOID;
    }

    private static boolean isBooleanGetterMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return method.getParameters().isEmpty() && name.startsWith("is") && name.length() > 2 && method.getReturnType().getKind() == TypeKind.BOOLEAN;
    }

    public static boolean isSetterMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return name.startsWith("set") && name.length() > 3 && method.getParameters().size() == 1 && method.getReturnType().getKind() == TypeKind.VOID;
    }

    public static String getPropertyName(ExecutableElement getterOrSetterMethod) {
        if (Executables.isNonBooleanGetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(getterOrSetterMethod.getSimpleName().toString().substring(3));
        }
        if (Executables.isBooleanGetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(getterOrSetterMethod.getSimpleName().toString().substring(2));
        }
        if (Executables.isSetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(getterOrSetterMethod.getSimpleName().toString().substring(3));
        }
        throw new IllegalArgumentException("Executable " + getterOrSetterMethod + " is not getter or setter method.");
    }

    public static ExecutableElement getCorrespondingSetterMethod(Element element, ExecutableElement getterMethod) {
        String propertyName = Executables.getPropertyName(getterMethod);
        for (ExecutableElement setterMethod : Filters.setterMethodsIn(element.getEnclosedElements())) {
            if (!Executables.getPropertyName(setterMethod).equals(propertyName)) continue;
            return setterMethod;
        }
        return null;
    }

    public static ExecutableElement getCorrespondingGetterMethod(Element element, ExecutableElement setterMethod) {
        String propertyName = Executables.getPropertyName(setterMethod);
        for (ExecutableElement getterMethod : Filters.getterMethodsIn(element.getEnclosedElements())) {
            if (!Executables.getPropertyName(getterMethod).equals(propertyName)) continue;
            return getterMethod;
        }
        return null;
    }
}

