/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.writer;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.Writer;
import javax.tools.JavaFileObject;

public class ModelWriter {
    private static final Configuration CONFIGURATION = new Configuration();
    private final String templateName;

    public ModelWriter(String templateName) {
        this.templateName = templateName;
    }

    public void writeModel(JavaFileObject sourceFile, Object model) {
        try {
            BufferedWriter writer = new BufferedWriter(sourceFile.openWriter());
            Template template = CONFIGURATION.getTemplate(this.templateName);
            template.process(model, (Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        CONFIGURATION.setClassForTemplateLoading(ModelWriter.class, "/");
        CONFIGURATION.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }
}

