/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import org.mapstruct.ap.conversion.ConversionProvider;
import org.mapstruct.ap.conversion.SimpleConversion;

public class BigDecimalToPrimitiveConversion
extends SimpleConversion {
    private final Class<?> targetType;

    public BigDecimalToPrimitiveConversion(Class<?> targetType) {
        if (!targetType.isPrimitive()) {
            throw new IllegalArgumentException(targetType + " is no primitive type.");
        }
        this.targetType = targetType;
    }

    @Override
    public String getToConversionString(String sourceReference, ConversionProvider.Context conversionContext) {
        return sourceReference + "." + this.targetType.getName() + "Value()";
    }

    @Override
    public String getFromConversionString(String targetReference, ConversionProvider.Context conversionContext) {
        StringBuilder conversion = new StringBuilder("BigDecimal.valueOf( ");
        conversion.append(targetReference).append(" )");
        return conversion.toString();
    }
}

