/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import org.mapstruct.ap.conversion.ConversionProvider;
import org.mapstruct.ap.conversion.SimpleConversion;
import org.mapstruct.ap.util.NativeTypes;
import org.mapstruct.ap.util.Strings;

public class WrapperToStringConversion
extends SimpleConversion {
    private final Class<?> sourceType;
    private final Class<?> primitiveType;

    public WrapperToStringConversion(Class<?> sourceType) {
        if (sourceType.isPrimitive()) {
            throw new IllegalArgumentException(sourceType + " is no wrapper type.");
        }
        this.sourceType = sourceType;
        this.primitiveType = NativeTypes.getPrimitiveType(sourceType);
    }

    @Override
    public String getToConversionString(String sourceReference, ConversionProvider.Context conversionContext) {
        return "String.valueOf( " + sourceReference + " )";
    }

    @Override
    public String getFromConversionString(String targetReference, ConversionProvider.Context conversionContext) {
        return this.sourceType.getSimpleName() + ".parse" + Strings.capitalize(this.primitiveType.getSimpleName()) + "( " + targetReference + " )";
    }
}

