/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import org.mapstruct.ap.conversion.ConversionProvider;
import org.mapstruct.ap.conversion.SimpleConversion;
import org.mapstruct.ap.util.NativeTypes;

public class WrapperToWrapperConversion
extends SimpleConversion {
    private final Class<?> sourceType;
    private final Class<?> targetType;

    public WrapperToWrapperConversion(Class<?> sourceType, Class<?> targetType) {
        if (sourceType.isPrimitive()) {
            throw new IllegalArgumentException(sourceType + " is no wrapper type.");
        }
        if (targetType.isPrimitive()) {
            throw new IllegalArgumentException(targetType + " is no wrapper type.");
        }
        this.sourceType = NativeTypes.getPrimitiveType(sourceType);
        this.targetType = NativeTypes.getPrimitiveType(targetType);
    }

    @Override
    public String getToConversionString(String sourceReference, ConversionProvider.Context conversionContext) {
        if (this.sourceType == this.targetType) {
            return sourceReference;
        }
        return sourceReference + "." + this.targetType.getName() + "Value()";
    }

    @Override
    public String getFromConversionString(String targetReference, ConversionProvider.Context conversionContext) {
        if (this.sourceType == this.targetType) {
            return targetReference;
        }
        return targetReference + "." + this.sourceType.getName() + "Value()";
    }
}

