/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Generated;
import org.mapstruct.ap.model.AbstractModelElement;
import org.mapstruct.ap.model.Annotation;
import org.mapstruct.ap.model.MapperReference;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.Options;
import org.mapstruct.ap.model.Type;
import org.mapstruct.ap.util.TypeFactory;

public class Mapper
extends AbstractModelElement {
    private final TypeFactory typeFactory;
    private final String packageName;
    private final String interfaceName;
    private final String implementationName;
    private final List<Annotation> annotations;
    private final List<MappingMethod> mappingMethods;
    private final List<MapperReference> referencedMappers;
    private final Options options;

    public Mapper(TypeFactory typeFactory, String packageName, String interfaceName, String implementationName, List<MappingMethod> mappingMethods, List<MapperReference> referencedMappers, Options options) {
        this.packageName = packageName;
        this.interfaceName = interfaceName;
        this.implementationName = implementationName;
        this.annotations = new ArrayList<Annotation>();
        this.mappingMethods = mappingMethods;
        this.referencedMappers = referencedMappers;
        this.options = options;
        this.typeFactory = typeFactory;
    }

    public SortedSet<Type> getImportTypes() {
        TreeSet<Type> importedTypes = new TreeSet<Type>();
        importedTypes.add(this.typeFactory.getType(Generated.class));
        for (MappingMethod mappingMethod : this.mappingMethods) {
            for (Type type : mappingMethod.getImportTypes()) {
                this.addWithDependents(importedTypes, type);
            }
        }
        for (MapperReference mapperReference : this.referencedMappers) {
            for (Type type : mapperReference.getImportTypes()) {
                this.addWithDependents(importedTypes, type);
            }
        }
        for (Annotation annotation : this.annotations) {
            this.addWithDependents(importedTypes, annotation.getType());
        }
        return importedTypes;
    }

    private void addWithDependents(Collection<Type> collection, Type typeToAdd) {
        if (typeToAdd == null) {
            return;
        }
        if (typeToAdd.getPackageName() != null && !typeToAdd.getPackageName().equals(this.packageName) && !typeToAdd.getPackageName().startsWith("java.lang")) {
            collection.add(typeToAdd);
        }
        this.addWithDependents(collection, typeToAdd.getImplementationType());
        for (Type type : typeToAdd.getTypeParameters()) {
            this.addWithDependents(collection, type);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Mapper {");
        sb.append("\n    packageName='" + this.packageName + "',");
        sb.append("\n    interfaceName='" + this.interfaceName + "',");
        sb.append("\n    implementationName='" + this.implementationName + "',");
        sb.append("\n    beanMappings=[");
        for (MappingMethod beanMapping : this.mappingMethods) {
            sb.append("\n        " + beanMapping.toString().replaceAll("\n", "\n        "));
        }
        sb.append("\n    ]");
        sb.append("\n    referencedMappers=" + this.referencedMappers);
        sb.append("\n},");
        return sb.toString();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public String getImplementationName() {
        return this.implementationName;
    }

    public List<MappingMethod> getMappingMethods() {
        return this.mappingMethods;
    }

    public List<MapperReference> getReferencedMappers() {
        return this.referencedMappers;
    }

    public Options getOptions() {
        return this.options;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }
}

