/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.Types;
import org.mapstruct.ap.model.AbstractModelElement;
import org.mapstruct.ap.util.Collections;

public class Type
extends AbstractModelElement
implements Comparable<Type> {
    private final String packageName;
    private final String name;
    private final String qualifiedName;
    private final List<Type> typeParameters;
    private final boolean isInterface;
    private final boolean isEnumType;
    private final boolean isIterableType;
    private final boolean isCollectionType;
    private final boolean isMapType;
    private final Type implementationType;
    private final TypeMirror typeMirror;
    private final Types typeUtils;
    private final TypeElement typeElement;

    public Type(TypeMirror typeMirror, List<Type> typeParameters, Type implementationType, boolean isIterableType, boolean isCollectionType, boolean isMapType, Types typeUtils, Elements elementUtils) {
        DeclaredType declaredType;
        this.typeMirror = typeMirror;
        this.implementationType = implementationType;
        this.typeParameters = typeParameters;
        this.isIterableType = isIterableType;
        this.isCollectionType = isCollectionType;
        this.isMapType = isMapType;
        this.typeUtils = typeUtils;
        DeclaredType declaredType2 = declaredType = typeMirror.getKind() == TypeKind.DECLARED ? (DeclaredType)typeMirror : null;
        if (declaredType != null) {
            this.isEnumType = declaredType.asElement().getKind() == ElementKind.ENUM;
            this.isInterface = declaredType.asElement().getKind() == ElementKind.INTERFACE;
            this.name = declaredType.asElement().getSimpleName().toString();
            this.typeElement = declaredType.asElement().accept(new TypeElementRetrievalVisitor(), null);
            if (this.typeElement != null) {
                this.packageName = elementUtils.getPackageOf(this.typeElement).getQualifiedName().toString();
                this.qualifiedName = this.typeElement.getQualifiedName().toString();
            } else {
                this.packageName = null;
                this.qualifiedName = this.name;
            }
        } else {
            this.isEnumType = false;
            this.isInterface = false;
            this.typeElement = null;
            this.name = typeMirror.toString();
            this.packageName = null;
            this.qualifiedName = this.name;
        }
    }

    public TypeMirror getTypeMirror() {
        return this.typeMirror;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public List<Type> getTypeParameters() {
        return this.typeParameters;
    }

    public boolean isPrimitive() {
        return this.typeMirror.getKind().isPrimitive();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isEnumType() {
        return this.isEnumType;
    }

    public Type getImplementationType() {
        return this.implementationType;
    }

    public boolean isIterableType() {
        return this.isIterableType;
    }

    public boolean isCollectionType() {
        return this.isCollectionType;
    }

    public boolean isMapType() {
        return this.isMapType;
    }

    public String getFullyQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public Set<Type> getImportTypes() {
        return this.implementationType != null ? Collections.asSet(this.implementationType) : java.util.Collections.emptySet();
    }

    public boolean isAssignableTo(Type other) {
        if (this.equals(other)) {
            return true;
        }
        return this.typeUtils.isAssignable(this.typeMirror, other.typeMirror);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        return this.typeUtils.isSameType(this.typeMirror, other.typeMirror);
    }

    @Override
    public int compareTo(Type o) {
        return this.getFullyQualifiedName().compareTo(o.getFullyQualifiedName());
    }

    public String toString() {
        return this.typeMirror.toString();
    }

    private static class TypeElementRetrievalVisitor
    extends SimpleElementVisitor6<TypeElement, Void> {
        private TypeElementRetrievalVisitor() {
        }

        @Override
        public TypeElement visitType(TypeElement e, Void p) {
            return e;
        }
    }
}

