/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.processor;

import java.beans.Introspector;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.mapstruct.ap.MapperPrism;
import org.mapstruct.ap.conversion.ConversionProvider;
import org.mapstruct.ap.conversion.Conversions;
import org.mapstruct.ap.conversion.DefaultConversionContext;
import org.mapstruct.ap.model.BeanMappingMethod;
import org.mapstruct.ap.model.DefaultMapperReference;
import org.mapstruct.ap.model.IterableMappingMethod;
import org.mapstruct.ap.model.MapMappingMethod;
import org.mapstruct.ap.model.Mapper;
import org.mapstruct.ap.model.MapperReference;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.MappingMethodReference;
import org.mapstruct.ap.model.Options;
import org.mapstruct.ap.model.Parameter;
import org.mapstruct.ap.model.PropertyMapping;
import org.mapstruct.ap.model.ReportingPolicy;
import org.mapstruct.ap.model.Type;
import org.mapstruct.ap.model.TypeConversion;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.processor.ModelElementProcessor;
import org.mapstruct.ap.util.Executables;
import org.mapstruct.ap.util.Filters;
import org.mapstruct.ap.util.Strings;
import org.mapstruct.ap.util.TypeFactory;

public class MapperCreationProcessor
implements ModelElementProcessor<List<Method>, Mapper> {
    private static final String IMPLEMENTATION_SUFFIX = "Impl";
    private Elements elementUtils;
    private Types typeUtils;
    private Messager messager;
    private Options options;
    private TypeFactory typeFactory;
    private Conversions conversions;
    private Executables executables;
    private Filters filters;

    @Override
    public Mapper process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, List<Method> sourceModel) {
        this.elementUtils = context.getElementUtils();
        this.typeUtils = context.getTypeUtils();
        this.messager = context.getMessager();
        this.options = context.getOptions();
        this.typeFactory = context.getTypeFactory();
        this.conversions = new Conversions(this.elementUtils, this.typeFactory);
        this.executables = new Executables(this.typeFactory);
        this.filters = new Filters(this.executables);
        return this.getMapper(mapperTypeElement, sourceModel);
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    private Mapper getMapper(TypeElement element, List<Method> methods) {
        ReportingPolicy unmappedTargetPolicy = this.getEffectiveUnmappedTargetPolicy(element);
        List<MappingMethod> mappingMethods = this.getMappingMethods(methods, unmappedTargetPolicy);
        List<MapperReference> mapperReferences = this.getReferencedMappers(element);
        return new Mapper(this.typeFactory, this.elementUtils.getPackageOf(element).getQualifiedName().toString(), element.getSimpleName().toString(), element.getSimpleName() + IMPLEMENTATION_SUFFIX, mappingMethods, mapperReferences, this.options);
    }

    private ReportingPolicy getEffectiveUnmappedTargetPolicy(TypeElement element) {
        MapperPrism mapperPrism = MapperPrism.getInstanceOn(element);
        boolean setViaAnnotation = mapperPrism.values.unmappedTargetPolicy() != null;
        ReportingPolicy annotationValue = ReportingPolicy.valueOf(mapperPrism.unmappedTargetPolicy());
        if (setViaAnnotation || this.options.getUnmappedTargetPolicy() == null) {
            return annotationValue;
        }
        return this.options.getUnmappedTargetPolicy();
    }

    private List<MapperReference> getReferencedMappers(TypeElement element) {
        LinkedList<MapperReference> mapperReferences = new LinkedList<MapperReference>();
        MapperPrism mapperPrism = MapperPrism.getInstanceOn(element);
        for (TypeMirror usedMapper : mapperPrism.uses()) {
            mapperReferences.add(new DefaultMapperReference(this.typeFactory.getType(usedMapper)));
        }
        return mapperReferences;
    }

    private List<MappingMethod> getMappingMethods(List<Method> methods, ReportingPolicy unmappedTargetPolicy) {
        ArrayList<MappingMethod> mappingMethods = new ArrayList<MappingMethod>();
        for (Method method : methods) {
            MappingMethod beanMappingMethod;
            if (method.getDeclaringMapper() != null) continue;
            this.reportErrorIfNoImplementationTypeIsRegisteredForInterfaceReturnType(method);
            Method reverseMappingMethod = this.getReverseMappingMethod(methods, method);
            if (method.isIterableMapping()) {
                if (method.getIterableMapping() == null && reverseMappingMethod != null && reverseMappingMethod.getIterableMapping() != null) {
                    method.setIterableMapping(reverseMappingMethod.getIterableMapping());
                }
                mappingMethods.add(this.getIterableMappingMethod(methods, method));
                continue;
            }
            if (method.isMapMapping()) {
                if (method.getMapMapping() == null && reverseMappingMethod != null && reverseMappingMethod.getMapMapping() != null) {
                    method.setMapMapping(reverseMappingMethod.getMapMapping());
                }
                mappingMethods.add(this.getMapMappingMethod(methods, method));
                continue;
            }
            if (method.getMappings().isEmpty() && reverseMappingMethod != null && !reverseMappingMethod.getMappings().isEmpty()) {
                method.setMappings(this.reverse(reverseMappingMethod.getMappings()));
            }
            if ((beanMappingMethod = this.getBeanMappingMethod(methods, method, unmappedTargetPolicy)) == null) continue;
            mappingMethods.add(beanMappingMethod);
        }
        return mappingMethods;
    }

    private void reportErrorIfNoImplementationTypeIsRegisteredForInterfaceReturnType(Method method) {
        if (method.getReturnType().getTypeMirror().getKind() != TypeKind.VOID && method.getReturnType().isInterface() && method.getReturnType().getImplementationType() == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("No implementation type is registered for return type %s.", method.getReturnType()), method.getExecutable());
        }
    }

    private Map<String, Mapping> reverse(Map<String, Mapping> mappings) {
        HashMap<String, Mapping> reversed = new HashMap<String, Mapping>();
        for (Mapping mapping : mappings.values()) {
            reversed.put(mapping.getTargetName(), mapping.reverse());
        }
        return reversed;
    }

    private PropertyMapping getPropertyMapping(List<Method> methods, Method method, ExecutableElement setterMethod, Parameter parameter) {
        String targetPropertyName = this.executables.getPropertyName(setterMethod);
        Mapping mapping = method.getMapping(targetPropertyName);
        String dateFormat = mapping != null ? mapping.getDateFormat() : null;
        String sourcePropertyName = mapping != null ? mapping.getSourcePropertyName() : targetPropertyName;
        TypeElement parameterElement = parameter.getType().getTypeElement();
        List<ExecutableElement> sourceGetters = this.filters.getterMethodsIn(this.elementUtils.getAllMembers(parameterElement));
        for (ExecutableElement getter : sourceGetters) {
            boolean mapsToOtherTarget;
            Mapping sourceMapping = method.getMappings().get(sourcePropertyName);
            boolean bl = mapsToOtherTarget = sourceMapping != null && !sourceMapping.getTargetName().equals(targetPropertyName);
            if (!this.executables.getPropertyName(getter).equals(sourcePropertyName) || mapsToOtherTarget) continue;
            return this.getPropertyMapping(methods, method, parameter, getter, setterMethod, dateFormat);
        }
        return null;
    }

    private MappingMethod getBeanMappingMethod(List<Method> methods, Method method, ReportingPolicy unmappedTargetPolicy) {
        ArrayList<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();
        HashSet<String> mappedTargetProperties = new HashSet<String>();
        if (!this.reportErrorIfMappedPropertiesDontExist(method)) {
            return null;
        }
        TypeElement resultTypeElement = method.getResultType().getTypeElement();
        List<ExecutableElement> targetSetters = this.filters.setterMethodsIn(this.elementUtils.getAllMembers(resultTypeElement));
        for (ExecutableElement setterMethod : targetSetters) {
            String targetPropertyName = this.executables.getPropertyName(setterMethod);
            Mapping mapping = method.getMapping(targetPropertyName);
            PropertyMapping propertyMapping = null;
            if (mapping != null && mapping.getSourceParameterName() != null) {
                Parameter parameter = method.getSourceParameter(mapping.getSourceParameterName());
                propertyMapping = this.getPropertyMapping(methods, method, setterMethod, parameter);
            }
            if (propertyMapping == null) {
                for (Parameter sourceParameter : method.getSourceParameters()) {
                    PropertyMapping newPropertyMapping = this.getPropertyMapping(methods, method, setterMethod, sourceParameter);
                    if (propertyMapping != null && newPropertyMapping != null) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Several possible source properties for target property \"" + targetPropertyName + "\".", method.getExecutable());
                        break;
                    }
                    if (newPropertyMapping == null) continue;
                    propertyMapping = newPropertyMapping;
                }
            }
            if (propertyMapping == null) continue;
            propertyMappings.add(propertyMapping);
            mappedTargetProperties.add(targetPropertyName);
        }
        Set<String> targetProperties = this.executables.getPropertyNames(targetSetters);
        this.reportErrorForUnmappedTargetPropertiesIfRequired(method, unmappedTargetPolicy, targetProperties, mappedTargetProperties);
        return new BeanMappingMethod(method, propertyMappings);
    }

    private void reportErrorForUnmappedTargetPropertiesIfRequired(Method method, ReportingPolicy unmappedTargetPolicy, Set<String> targetProperties, Set<String> mappedTargetProperties) {
        if (targetProperties.size() > mappedTargetProperties.size() && unmappedTargetPolicy.requiresReport()) {
            targetProperties.removeAll(mappedTargetProperties);
            this.messager.printMessage(unmappedTargetPolicy.getDiagnosticKind(), MessageFormat.format("Unmapped target {0,choice,1#property|1<properties}: \"{1}\"", targetProperties.size(), Strings.join(targetProperties, ", ")), method.getExecutable());
        }
    }

    private Method getReverseMappingMethod(List<Method> rawMethods, Method method) {
        for (Method oneMethod : rawMethods) {
            if (!oneMethod.reverses(method)) continue;
            return oneMethod;
        }
        return null;
    }

    private boolean hasSourceProperty(Method method, String propertyName) {
        for (Parameter parameter : method.getSourceParameters()) {
            if (!this.hasProperty(parameter, propertyName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasProperty(Parameter parameter, String propertyName) {
        TypeElement parameterTypeElement = parameter.getType().getTypeElement();
        List<ExecutableElement> getters = this.filters.setterMethodsIn(this.elementUtils.getAllMembers(parameterTypeElement));
        return this.executables.getPropertyNames(getters).contains(propertyName);
    }

    private boolean reportErrorIfMappedPropertiesDontExist(Method method) {
        TypeElement resultTypeElement = method.getResultType().getTypeElement();
        List<ExecutableElement> targetSetters = this.filters.setterMethodsIn(this.elementUtils.getAllMembers(resultTypeElement));
        Set<String> targetProperties = this.executables.getPropertyNames(targetSetters);
        boolean foundUnmappedProperty = false;
        for (Mapping mappedProperty : method.getMappings().values()) {
            if (mappedProperty.getSourceParameterName() != null) {
                Parameter sourceParameter = method.getSourceParameter(mappedProperty.getSourceParameterName());
                if (sourceParameter == null) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Method has no parameter named \"%s\".", mappedProperty.getSourceParameterName()), method.getExecutable(), mappedProperty.getMirror(), mappedProperty.getSourceAnnotationValue());
                    foundUnmappedProperty = true;
                } else if (!this.hasProperty(sourceParameter, mappedProperty.getSourcePropertyName())) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("The type of parameter \"%s\" has no property named \"%s\".", mappedProperty.getSourceParameterName(), mappedProperty.getSourcePropertyName()), method.getExecutable(), mappedProperty.getMirror(), mappedProperty.getSourceAnnotationValue());
                    foundUnmappedProperty = true;
                }
            } else if (!this.hasSourceProperty(method, mappedProperty.getSourcePropertyName())) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("No property named \"%s\" exists in source parameter(s).", mappedProperty.getSourceName()), method.getExecutable(), mappedProperty.getMirror(), mappedProperty.getSourceAnnotationValue());
                foundUnmappedProperty = true;
            }
            if (targetProperties.contains(mappedProperty.getTargetName())) continue;
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Unknown property \"%s\" in return type %s.", mappedProperty.getTargetName(), method.getResultType()), method.getExecutable(), mappedProperty.getMirror(), mappedProperty.getTargetAnnotationValue());
            foundUnmappedProperty = true;
        }
        return !foundUnmappedProperty;
    }

    private PropertyMapping getPropertyMapping(List<Method> methods, Method method, Parameter parameter, ExecutableElement getterMethod, ExecutableElement setterMethod, String dateFormat) {
        Type sourceType = this.executables.retrieveReturnType(getterMethod);
        Type targetType = this.executables.retrieveSingleParameter(setterMethod).getType();
        MappingMethodReference propertyMappingMethod = this.getMappingMethodReference(methods, sourceType, targetType);
        TypeConversion conversion = this.getConversion(sourceType, targetType, dateFormat, parameter.getName() + "." + getterMethod.getSimpleName().toString() + "()");
        PropertyMapping property = new PropertyMapping(parameter.getName(), this.executables.getPropertyName(getterMethod), getterMethod.getSimpleName().toString(), sourceType, this.executables.getPropertyName(setterMethod), setterMethod.getSimpleName().toString(), targetType, propertyMappingMethod, conversion);
        this.reportErrorIfPropertyCanNotBeMapped(method, property);
        return property;
    }

    private MappingMethod getIterableMappingMethod(List<Method> methods, Method method) {
        Type sourceElementType = method.getSourceParameters().iterator().next().getType().getTypeParameters().get(0);
        Type targetElementType = method.getResultType().getTypeParameters().get(0);
        TypeConversion conversion = this.getConversion(sourceElementType, targetElementType, method.getIterableMapping() != null ? method.getIterableMapping().getDateFormat() : null, Strings.getSaveVariableName(Introspector.decapitalize(sourceElementType.getName()), method.getParameterNames()));
        return new IterableMappingMethod(method, this.getMappingMethodReference(methods, sourceElementType, targetElementType), conversion);
    }

    private MappingMethod getMapMappingMethod(List<Method> methods, Method method) {
        List<Type> sourceTypeParams = method.getSourceParameters().iterator().next().getType().getTypeParameters();
        Type sourceKeyType = sourceTypeParams.get(0);
        Type sourceValueType = sourceTypeParams.get(1);
        List<Type> resultTypeParams = method.getResultType().getTypeParameters();
        Type targetKeyType = resultTypeParams.get(0);
        Type targetValueType = resultTypeParams.get(1);
        String keyDateFormat = method.getMapMapping() != null ? method.getMapMapping().getKeyFormat() : null;
        String valueDateFormat = method.getMapMapping() != null ? method.getMapMapping().getValueFormat() : null;
        TypeConversion keyConversion = this.getConversion(sourceKeyType, targetKeyType, keyDateFormat, "entry.getKey()");
        TypeConversion valueConversion = this.getConversion(sourceValueType, targetValueType, valueDateFormat, "entry.getValue()");
        MappingMethodReference keyMappingMethod = this.getMappingMethodReference(methods, sourceKeyType, targetKeyType);
        MappingMethodReference valueMappingMethod = this.getMappingMethodReference(methods, sourceValueType, targetValueType);
        return new MapMappingMethod(method, keyMappingMethod, keyConversion, valueMappingMethod, valueConversion);
    }

    private TypeConversion getConversion(Type sourceType, Type targetType, String dateFormat, String sourceReference) {
        ConversionProvider conversionProvider = this.conversions.getConversion(sourceType, targetType);
        if (conversionProvider == null) {
            return null;
        }
        return conversionProvider.to(sourceReference, new DefaultConversionContext(this.typeFactory, targetType, dateFormat));
    }

    private MappingMethodReference getMappingMethodReference(Iterable<Method> methods, Type parameterType, Type returnType) {
        for (Method method : methods) {
            Parameter singleSourceParam;
            if (method.getSourceParameters().size() > 1 || !(singleSourceParam = method.getSourceParameters().iterator().next()).getType().equals(parameterType) || !method.getResultType().equals(returnType)) continue;
            return new MappingMethodReference(method);
        }
        return null;
    }

    private void reportErrorIfPropertyCanNotBeMapped(Method method, PropertyMapping property) {
        boolean collectionOrMapTargetTypeHasCompatibleConstructor = false;
        if (property.getTargetType().isCollectionType() || property.getTargetType().isMapType()) {
            collectionOrMapTargetTypeHasCompatibleConstructor = property.getTargetType().getImplementationType() != null ? this.hasCompatibleConstructor(property.getSourceType(), property.getTargetType().getImplementationType()) : this.hasCompatibleConstructor(property.getSourceType(), property.getTargetType());
        }
        if (property.getSourceType().isAssignableTo(property.getTargetType()) || property.getMappingMethod() != null || property.getConversion() != null || (property.getTargetType().isCollectionType() || property.getTargetType().isMapType()) && collectionOrMapTargetTypeHasCompatibleConstructor) {
            return;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Can't map property \"%s %s\" to \"%s %s\".", property.getSourceType(), property.getSourceName(), property.getTargetType(), property.getTargetName()), method.getExecutable());
    }

    private boolean hasCompatibleConstructor(Type sourceType, Type targetType) {
        List<ExecutableElement> targetTypeConstructors = ElementFilter.constructorsIn(targetType.getTypeElement().getEnclosedElements());
        for (ExecutableElement constructor : targetTypeConstructors) {
            if (constructor.getParameters().size() != 1) continue;
            ExecutableType typedConstructor = (ExecutableType)this.typeUtils.asMemberOf((DeclaredType)targetType.getTypeMirror(), constructor);
            if (!this.typeUtils.isAssignable(sourceType.getTypeMirror(), typedConstructor.getParameterTypes().iterator().next())) continue;
            return true;
        }
        return false;
    }
}

