/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.model.Type;

public class TypeFactory {
    private final Elements elementUtils;
    private final Types typeUtils;
    private final TypeMirror iterableType;
    private final TypeMirror collectionType;
    private final TypeMirror mapType;
    private final Map<String, Type> implementationTypes = new HashMap<String, Type>();

    public TypeFactory(Elements elementUtils, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.iterableType = typeUtils.erasure(elementUtils.getTypeElement(Iterable.class.getCanonicalName()).asType());
        this.collectionType = typeUtils.erasure(elementUtils.getTypeElement(Collection.class.getCanonicalName()).asType());
        this.mapType = typeUtils.erasure(elementUtils.getTypeElement(Map.class.getCanonicalName()).asType());
        this.implementationTypes.put(Iterable.class.getName(), this.getType(ArrayList.class));
        this.implementationTypes.put(Collection.class.getName(), this.getType(ArrayList.class));
        this.implementationTypes.put(List.class.getName(), this.getType(ArrayList.class));
        this.implementationTypes.put(Set.class.getName(), this.getType(HashSet.class));
        this.implementationTypes.put(SortedSet.class.getName(), this.getType(TreeSet.class));
        this.implementationTypes.put(NavigableSet.class.getName(), this.getType(TreeSet.class));
        this.implementationTypes.put(Map.class.getName(), this.getType(HashMap.class));
        this.implementationTypes.put(SortedMap.class.getName(), this.getType(TreeMap.class));
        this.implementationTypes.put(NavigableMap.class.getName(), this.getType(TreeMap.class));
        this.implementationTypes.put(ConcurrentMap.class.getName(), this.getType(ConcurrentHashMap.class));
        this.implementationTypes.put(ConcurrentNavigableMap.class.getName(), this.getType(ConcurrentSkipListMap.class));
    }

    public Type getType(Class<?> type) {
        return type.isPrimitive() ? this.getType(this.getPrimitiveType(type)) : this.getType(type.getCanonicalName());
    }

    public Type getType(String canonicalName) {
        TypeElement typeElement = this.elementUtils.getTypeElement(canonicalName);
        return this.getType(typeElement);
    }

    public Type getType(TypeElement typeElement) {
        return this.getType(typeElement.asType());
    }

    public Type getType(TypeMirror mirror) {
        Type implementationType = this.getImplementationType(mirror);
        boolean isIterableType = this.typeUtils.isSubtype(mirror, this.iterableType);
        boolean isCollectionType = this.typeUtils.isSubtype(mirror, this.collectionType);
        boolean isMapType = this.typeUtils.isSubtype(mirror, this.mapType);
        return new Type(mirror, this.getTypeParameters(mirror), implementationType, isIterableType, isCollectionType, isMapType, this.typeUtils, this.elementUtils);
    }

    private List<Type> getTypeParameters(TypeMirror mirror) {
        if (mirror.getKind() != TypeKind.DECLARED) {
            return Collections.emptyList();
        }
        DeclaredType declaredType = (DeclaredType)mirror;
        ArrayList<Type> typeParameters = new ArrayList<Type>(declaredType.getTypeArguments().size());
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            typeParameters.add(this.getType(typeMirror));
        }
        return typeParameters;
    }

    private TypeMirror getPrimitiveType(Class<?> primitiveType) {
        return primitiveType == Byte.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.BYTE) : (primitiveType == Short.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.SHORT) : (primitiveType == Integer.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.INT) : (primitiveType == Long.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.LONG) : (primitiveType == Float.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.FLOAT) : (primitiveType == Double.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.DOUBLE) : (primitiveType == Boolean.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.BOOLEAN) : (primitiveType == Character.TYPE ? this.typeUtils.getPrimitiveType(TypeKind.CHAR) : this.typeUtils.getPrimitiveType(TypeKind.VOID))))))));
    }

    private Type getImplementationType(TypeMirror mirror) {
        if (mirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        DeclaredType declaredType = (DeclaredType)mirror;
        Type implementationType = this.implementationTypes.get(((TypeElement)declaredType.asElement()).getQualifiedName().toString());
        if (implementationType != null) {
            return new Type(this.typeUtils.getDeclaredType(implementationType.getTypeElement(), declaredType.getTypeArguments().toArray(new TypeMirror[0])), this.getTypeParameters(mirror), null, implementationType.isIterableType(), implementationType.isCollectionType(), implementationType.isMapType(), this.typeUtils, this.elementUtils);
        }
        return null;
    }
}

