/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import org.mapstruct.ap.conversion.SimpleConversion;
import org.mapstruct.ap.model.common.ConversionContext;
import org.mapstruct.ap.util.NativeTypes;

public class BigDecimalToWrapperConversion
extends SimpleConversion {
    private final Class<?> targetType;

    public BigDecimalToWrapperConversion(Class<?> targetType) {
        if (targetType.isPrimitive()) {
            throw new IllegalArgumentException(targetType + " is a primitive type.");
        }
        this.targetType = NativeTypes.getPrimitiveType(targetType);
    }

    @Override
    public String getToConversionString(String sourceReference, ConversionContext conversionContext) {
        return sourceReference + "." + this.targetType.getName() + "Value()";
    }

    @Override
    public String getFromConversionString(String targetReference, ConversionContext conversionContext) {
        StringBuilder conversion = new StringBuilder("BigDecimal.valueOf( ");
        conversion.append(targetReference);
        conversion.append(" )");
        return conversion.toString();
    }
}

