/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import org.mapstruct.ap.conversion.SimpleConversion;
import org.mapstruct.ap.model.common.ConversionContext;

public class BigIntegerToPrimitiveConversion
extends SimpleConversion {
    private final Class<?> targetType;

    public BigIntegerToPrimitiveConversion(Class<?> targetType) {
        if (!targetType.isPrimitive()) {
            throw new IllegalArgumentException(targetType + " is no primitive type.");
        }
        this.targetType = targetType;
    }

    @Override
    public String getToConversionString(String sourceReference, ConversionContext conversionContext) {
        return sourceReference + "." + this.targetType.getName() + "Value()";
    }

    @Override
    public String getFromConversionString(String targetReference, ConversionContext conversionContext) {
        StringBuilder conversion = new StringBuilder("BigInteger.valueOf( ");
        if (this.targetType == Float.TYPE || this.targetType == Double.TYPE) {
            conversion.append("(long) ");
        }
        conversion.append(targetReference).append(" )");
        return conversion.toString();
    }
}

