/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.MethodReference;
import org.mapstruct.ap.model.PropertyMapping;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.SourceMethod;

public class BeanMappingMethod
extends MappingMethod {
    private final List<PropertyMapping> propertyMappings;
    private final MethodReference factoryMethod;

    public BeanMappingMethod(SourceMethod method, List<PropertyMapping> propertyMappings, MethodReference factoryMethod) {
        super(method);
        this.propertyMappings = propertyMappings;
        this.factoryMethod = factoryMethod;
    }

    public List<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings;
    }

    public Map<String, List<PropertyMapping>> getPropertyMappingsByParameter() {
        HashMap<String, List<PropertyMapping>> mappingsByParameter = new HashMap<String, List<PropertyMapping>>();
        for (Parameter sourceParameter : this.getSourceParameters()) {
            ArrayList<PropertyMapping> mappingsOfParameter = new ArrayList<PropertyMapping>();
            mappingsByParameter.put(sourceParameter.getName(), mappingsOfParameter);
            for (PropertyMapping mapping : this.propertyMappings) {
                if (!mapping.getSourceBeanName().equals(sourceParameter.getName())) continue;
                mappingsOfParameter.add(mapping);
            }
        }
        return mappingsByParameter;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        for (PropertyMapping propertyMapping : this.propertyMappings) {
            types.addAll(propertyMapping.getImportTypes());
        }
        return types;
    }

    public MethodReference getFactoryMethod() {
        return this.factoryMethod;
    }
}

