/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Generated;
import org.mapstruct.ap.model.Annotation;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.common.Accessibility;
import org.mapstruct.ap.model.common.ModelElement;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;

public abstract class GeneratedType
extends ModelElement {
    private final String packageName;
    private final String name;
    private final String superClassName;
    private final String interfaceName;
    private final List<Annotation> annotations;
    private final List<MappingMethod> methods;
    private final List<? extends ModelElement> fields;
    private final boolean suppressGeneratorTimestamp;
    private final Accessibility accessibility;
    private final Type generatedType;

    protected GeneratedType(TypeFactory typeFactory, String packageName, String name, String superClassName, String interfaceName, List<MappingMethod> methods, List<? extends ModelElement> fields, boolean suppressGeneratorTimestamp, Accessibility accessibility) {
        this.packageName = packageName;
        this.name = name;
        this.superClassName = superClassName;
        this.interfaceName = interfaceName;
        this.annotations = new ArrayList<Annotation>();
        this.methods = methods;
        this.fields = fields;
        this.suppressGeneratorTimestamp = suppressGeneratorTimestamp;
        this.accessibility = accessibility;
        this.generatedType = typeFactory.getType(Generated.class);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public List<MappingMethod> getMethods() {
        return this.methods;
    }

    public List<? extends ModelElement> getFields() {
        return this.fields;
    }

    public boolean isSuppressGeneratorTimestamp() {
        return this.suppressGeneratorTimestamp;
    }

    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public SortedSet<Type> getImportTypes() {
        TreeSet<Type> importedTypes = new TreeSet<Type>();
        importedTypes.add(this.generatedType);
        for (MappingMethod mappingMethod : this.methods) {
            for (Type type : mappingMethod.getImportTypes()) {
                this.addWithDependents(importedTypes, type);
            }
        }
        for (ModelElement modelElement : this.fields) {
            for (Type type : modelElement.getImportTypes()) {
                this.addWithDependents(importedTypes, type);
            }
        }
        for (Annotation annotation : this.annotations) {
            this.addWithDependents(importedTypes, annotation.getType());
        }
        return importedTypes;
    }

    private void addWithDependents(Collection<Type> collection, Type typeToAdd) {
        if (typeToAdd == null) {
            return;
        }
        if (typeToAdd.isImported() && typeToAdd.getPackageName() != null && !typeToAdd.getPackageName().equals(this.packageName) && !typeToAdd.getPackageName().startsWith("java.lang")) {
            collection.add(typeToAdd);
        }
        this.addWithDependents(collection, typeToAdd.getImplementationType());
        for (Type type : typeToAdd.getTypeParameters()) {
            this.addWithDependents(collection, type);
        }
    }
}

