/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.Set;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.MethodReference;
import org.mapstruct.ap.model.TypeConversion;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.util.Strings;

public class IterableMappingMethod
extends MappingMethod {
    private final MethodReference elementMappingMethod;
    private final TypeConversion conversion;
    private final MethodReference factoryMethod;

    public IterableMappingMethod(SourceMethod method, MethodReference elementMappingMethod, TypeConversion conversion, MethodReference factoryMethod) {
        super(method);
        this.elementMappingMethod = elementMappingMethod;
        this.conversion = conversion;
        this.factoryMethod = factoryMethod;
    }

    public Parameter getSourceParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget()) continue;
            return parameter;
        }
        throw new IllegalStateException("Method " + this + " has no source parameter.");
    }

    public MethodReference getElementMappingMethod() {
        return this.elementMappingMethod;
    }

    public TypeConversion getConversion() {
        return this.conversion;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        if (this.conversion != null) {
            types.addAll(this.conversion.getImportTypes());
        }
        return types;
    }

    public String getLoopVariableName() {
        return Strings.getSaveVariableName(this.getSourceParameter().getType().getTypeParameters().get(0).getName(), this.getParameterNames());
    }

    public MethodReference getFactoryMethod() {
        return this.factoryMethod;
    }
}

