/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.model.common.Accessibility;
import org.mapstruct.ap.model.common.ModelElement;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.util.Strings;

public abstract class MappingMethod
extends ModelElement {
    private final String name;
    private final List<Parameter> parameters;
    private final Type returnType;
    private final Parameter targetParameter;
    private final Accessibility accessibility;

    protected MappingMethod(Method method) {
        this.name = method.getName();
        this.parameters = method.getParameters();
        this.returnType = method.getReturnType();
        this.targetParameter = method.getTargetParameter();
        this.accessibility = method.getAccessibility();
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<Parameter> getSourceParameters() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter parameter : this.parameters) {
            if (parameter.isMappingTarget()) continue;
            sourceParameters.add(parameter);
        }
        return sourceParameters;
    }

    public Type getResultType() {
        return this.targetParameter != null ? this.targetParameter.getType() : this.returnType;
    }

    public String getResultName() {
        return this.targetParameter != null ? this.targetParameter.getName() : Strings.getSaveVariableName(this.getResultType().getName(), this.getParameterNames());
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public boolean isExistingInstanceMapping() {
        return this.targetParameter != null;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> types = new HashSet<Type>();
        for (Parameter param : this.parameters) {
            types.add(param.getType());
        }
        types.add(this.getReturnType());
        types.addAll(this.getReturnType().getImportTypes());
        return types;
    }

    protected List<String> getParameterNames() {
        ArrayList<String> parameterNames = new ArrayList<String>(this.parameters.size());
        for (Parameter parameter : this.parameters) {
            parameterNames.add(parameter.getName());
        }
        return parameterNames;
    }

    public String toString() {
        return this.returnType + " " + this.getName() + "(" + Strings.join(this.parameters, ", ") + ")";
    }
}

