/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source.selector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.util.Types;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.model.source.selector.InheritanceSelector;
import org.mapstruct.ap.model.source.selector.MethodSelector;
import org.mapstruct.ap.model.source.selector.TypeSelector;
import org.mapstruct.ap.model.source.selector.XmlElementDeclSelector;

public class MethodSelectors
implements MethodSelector {
    private final List<MethodSelector> selectors;

    public MethodSelectors(Types typeUtils, TypeFactory typeFactory) {
        this.selectors = Arrays.asList(new TypeSelector(typeFactory), new InheritanceSelector(), new XmlElementDeclSelector(typeUtils));
    }

    @Override
    public <T extends Method> List<T> getMatchingMethods(SourceMethod mappingMethod, List<T> methods, Type parameterType, Type returnType, String targetPropertyName) {
        List<T> candidates = new ArrayList<T>(methods);
        for (MethodSelector selector : this.selectors) {
            candidates = selector.getMatchingMethods(mappingMethod, candidates, parameterType, returnType, targetPropertyName);
        }
        return candidates;
    }

    public static List<Type> getParameterTypes(TypeFactory typeFactory, List<Parameter> parameters, Type sourceType, Type returnType) {
        ArrayList<Type> result = new ArrayList<Type>(parameters.size());
        for (Parameter param : parameters) {
            if (param.isTargetType()) {
                result.add(typeFactory.classTypeOf(returnType));
                continue;
            }
            result.add(sourceType);
        }
        return result;
    }
}

