/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.prism;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class XmlElementDeclPrism {
    private TypeMirror _scope;
    private String _namespace;
    private String _name;
    private String _substitutionHeadNamespace;
    private String _substitutionHeadName;
    private String _defaultValue;
    public final Values values;
    public final boolean isValid;
    public final AnnotationMirror mirror;
    private Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    public static XmlElementDeclPrism getInstanceOn(Element e) {
        AnnotationMirror m = XmlElementDeclPrism.getMirror("javax.xml.bind.annotation.XmlElementDecl", e);
        if (m == null) {
            return null;
        }
        return XmlElementDeclPrism.getInstance(m);
    }

    public static XmlElementDeclPrism getInstance(AnnotationMirror mirror) {
        return new XmlElementDeclPrism(mirror);
    }

    private XmlElementDeclPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._scope = this.getValue("scope", TypeMirror.class);
        this._namespace = this.getValue("namespace", String.class);
        this._name = this.getValue("name", String.class);
        this._substitutionHeadNamespace = this.getValue("substitutionHeadNamespace", String.class);
        this._substitutionHeadName = this.getValue("substitutionHeadName", String.class);
        this._defaultValue = this.getValue("defaultValue", String.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public TypeMirror scope() {
        return this._scope;
    }

    public String namespace() {
        return this._namespace;
    }

    public String name() {
        return this._name;
    }

    public String substitutionHeadNamespace() {
        return this._substitutionHeadNamespace;
    }

    public String substitutionHeadName() {
        return this._substitutionHeadName;
    }

    public String defaultValue() {
        return this._defaultValue;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = XmlElementDeclPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = XmlElementDeclPrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(String fqn, Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!fqn.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : XmlElementDeclPrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return null;
            }
            return result;
        }
        return null;
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    public static class Values {
        private Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        public AnnotationValue scope() {
            return this.values.get("scope");
        }

        public AnnotationValue namespace() {
            return this.values.get("namespace");
        }

        public AnnotationValue name() {
            return this.values.get("name");
        }

        public AnnotationValue substitutionHeadNamespace() {
            return this.values.get("substitutionHeadNamespace");
        }

        public AnnotationValue substitutionHeadName() {
            return this.values.get("substitutionHeadName");
        }

        public AnnotationValue defaultValue() {
            return this.values.get("defaultValue");
        }
    }
}

