/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.processor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.mapstruct.ap.conversion.ConversionProvider;
import org.mapstruct.ap.conversion.Conversions;
import org.mapstruct.ap.model.BeanMappingMethod;
import org.mapstruct.ap.model.Decorator;
import org.mapstruct.ap.model.DefaultMapperReference;
import org.mapstruct.ap.model.DelegatingMethod;
import org.mapstruct.ap.model.EnumMappingMethod;
import org.mapstruct.ap.model.IterableMappingMethod;
import org.mapstruct.ap.model.MapMappingMethod;
import org.mapstruct.ap.model.Mapper;
import org.mapstruct.ap.model.MapperReference;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.MethodReference;
import org.mapstruct.ap.model.PropertyMapping;
import org.mapstruct.ap.model.TypeConversion;
import org.mapstruct.ap.model.VirtualMappingMethod;
import org.mapstruct.ap.model.common.DefaultConversionContext;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.model.source.EnumMapping;
import org.mapstruct.ap.model.source.Mapping;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.model.source.builtin.BuiltInMappingMethods;
import org.mapstruct.ap.model.source.builtin.BuiltInMethod;
import org.mapstruct.ap.model.source.selector.MethodSelectors;
import org.mapstruct.ap.option.Options;
import org.mapstruct.ap.option.ReportingPolicy;
import org.mapstruct.ap.prism.DecoratedWithPrism;
import org.mapstruct.ap.prism.MapperPrism;
import org.mapstruct.ap.processor.ModelElementProcessor;
import org.mapstruct.ap.util.Executables;
import org.mapstruct.ap.util.Filters;
import org.mapstruct.ap.util.Strings;

public class MapperCreationProcessor
implements ModelElementProcessor<List<SourceMethod>, Mapper> {
    private Elements elementUtils;
    private Types typeUtils;
    private Messager messager;
    private Options options;
    private TypeFactory typeFactory;
    private Conversions conversions;
    private BuiltInMappingMethods builtInMethods;
    private MethodSelectors methodSelectors;
    private Set<VirtualMappingMethod> virtualMethods;

    @Override
    public Mapper process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, List<SourceMethod> sourceModel) {
        this.elementUtils = context.getElementUtils();
        this.typeUtils = context.getTypeUtils();
        this.messager = context.getMessager();
        this.options = context.getOptions();
        this.typeFactory = context.getTypeFactory();
        this.conversions = new Conversions(this.elementUtils, this.typeFactory);
        this.builtInMethods = new BuiltInMappingMethods(this.typeFactory);
        this.virtualMethods = new HashSet<VirtualMappingMethod>();
        this.methodSelectors = new MethodSelectors(this.typeUtils, this.typeFactory);
        return this.getMapper(mapperTypeElement, sourceModel);
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    private Mapper getMapper(TypeElement element, List<SourceMethod> methods) {
        ReportingPolicy unmappedTargetPolicy = this.getEffectiveUnmappedTargetPolicy(element);
        List<MapperReference> mapperReferences = this.getReferencedMappers(element);
        List<MappingMethod> mappingMethods = this.getMappingMethods(mapperReferences, methods, unmappedTargetPolicy);
        mappingMethods.addAll(this.virtualMethods);
        Mapper mapper = new Mapper.Builder().element(element).mappingMethods(mappingMethods).mapperReferences(mapperReferences).suppressGeneratorTimestamp(this.options.isSuppressGeneratorTimestamp()).decorator(this.getDecorator(element, methods)).typeFactory(this.typeFactory).elementUtils(this.elementUtils).build();
        return mapper;
    }

    private ReportingPolicy getEffectiveUnmappedTargetPolicy(TypeElement element) {
        MapperPrism mapperPrism = MapperPrism.getInstanceOn(element);
        boolean setViaAnnotation = mapperPrism.values.unmappedTargetPolicy() != null;
        ReportingPolicy annotationValue = ReportingPolicy.valueOf(mapperPrism.unmappedTargetPolicy());
        if (setViaAnnotation || this.options.getUnmappedTargetPolicy() == null) {
            return annotationValue;
        }
        return this.options.getUnmappedTargetPolicy();
    }

    private Decorator getDecorator(TypeElement element, List<SourceMethod> methods) {
        DecoratedWithPrism decoratorPrism = DecoratedWithPrism.getInstanceOn(element);
        if (decoratorPrism == null) {
            return null;
        }
        TypeElement decoratorElement = (TypeElement)this.typeUtils.asElement(decoratorPrism.value());
        if (!this.typeUtils.isAssignable(decoratorElement.asType(), element.asType())) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Specified decorator type is no subtype of the annotated mapper type.", new Object[0]), element, decoratorPrism.mirror);
        }
        ArrayList<MappingMethod> mappingMethods = new ArrayList<MappingMethod>(methods.size());
        for (SourceMethod mappingMethod : methods) {
            boolean implementationRequired = true;
            for (ExecutableElement method : ElementFilter.methodsIn(decoratorElement.getEnclosedElements())) {
                if (!this.elementUtils.overrides(method, mappingMethod.getExecutable(), decoratorElement)) continue;
                implementationRequired = false;
                break;
            }
            if (!implementationRequired) continue;
            mappingMethods.add(new DelegatingMethod(mappingMethod));
        }
        boolean hasDelegateConstructor = false;
        boolean hasDefaultConstructor = false;
        for (ExecutableElement constructor : ElementFilter.constructorsIn(decoratorElement.getEnclosedElements())) {
            if (constructor.getParameters().isEmpty()) {
                hasDefaultConstructor = true;
                continue;
            }
            if (constructor.getParameters().size() != 1 || !this.typeUtils.isAssignable(element.asType(), constructor.getParameters().iterator().next().asType())) continue;
            hasDelegateConstructor = true;
        }
        if (!hasDelegateConstructor && !hasDefaultConstructor) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Specified decorator type has no default constructor nor a constructor with a single parameter accepting the decorated mapper type.", new Object[0]), element, decoratorPrism.mirror);
        }
        return Decorator.getInstance(this.elementUtils, this.typeFactory, element, decoratorPrism, mappingMethods, hasDelegateConstructor, this.options.isSuppressGeneratorTimestamp());
    }

    private List<MapperReference> getReferencedMappers(TypeElement element) {
        LinkedList<MapperReference> mapperReferences = new LinkedList<MapperReference>();
        LinkedList<String> variableNames = new LinkedList<String>();
        MapperPrism mapperPrism = MapperPrism.getInstanceOn(element);
        for (TypeMirror usedMapper : mapperPrism.uses()) {
            DefaultMapperReference mapperReference = DefaultMapperReference.getInstance(this.typeFactory.getType(usedMapper), MapperPrism.getInstanceOn(this.typeUtils.asElement(usedMapper)) != null, this.typeFactory, variableNames);
            mapperReferences.add(mapperReference);
            variableNames.add(mapperReference.getVariableName());
        }
        return mapperReferences;
    }

    private List<MappingMethod> getMappingMethods(List<MapperReference> mapperReferences, List<SourceMethod> methods, ReportingPolicy unmappedTargetPolicy) {
        ArrayList<MappingMethod> mappingMethods = new ArrayList<MappingMethod>();
        for (SourceMethod method : methods) {
            if (!method.requiresImplementation()) continue;
            SourceMethod reverseMappingMethod = this.getReverseMappingMethod(methods, method);
            boolean hasFactoryMethod = false;
            if (method.isIterableMapping()) {
                IterableMappingMethod iterableMappingMethod;
                if (method.getIterableMapping() == null && reverseMappingMethod != null && reverseMappingMethod.getIterableMapping() != null) {
                    method.setIterableMapping(reverseMappingMethod.getIterableMapping());
                }
                hasFactoryMethod = (iterableMappingMethod = this.getIterableMappingMethod(mapperReferences, methods, method)).getFactoryMethod() != null;
                mappingMethods.add(iterableMappingMethod);
            } else if (method.isMapMapping()) {
                MapMappingMethod mapMappingMethod;
                if (method.getMapMapping() == null && reverseMappingMethod != null && reverseMappingMethod.getMapMapping() != null) {
                    method.setMapMapping(reverseMappingMethod.getMapMapping());
                }
                hasFactoryMethod = (mapMappingMethod = this.getMapMappingMethod(mapperReferences, methods, method)).getFactoryMethod() != null;
                mappingMethods.add(mapMappingMethod);
            } else if (method.isEnumMapping()) {
                EnumMappingMethod enumMappingMethod;
                if (method.getMappings().isEmpty() && reverseMappingMethod != null && !reverseMappingMethod.getMappings().isEmpty()) {
                    method.setMappings(this.reverse(reverseMappingMethod.getMappings()));
                }
                if ((enumMappingMethod = this.getEnumMappingMethod(method)) != null) {
                    mappingMethods.add(enumMappingMethod);
                }
            } else {
                BeanMappingMethod beanMappingMethod;
                if (method.getMappings().isEmpty() && reverseMappingMethod != null && !reverseMappingMethod.getMappings().isEmpty()) {
                    method.setMappings(this.reverse(reverseMappingMethod.getMappings()));
                }
                if ((beanMappingMethod = this.getBeanMappingMethod(mapperReferences, methods, method, unmappedTargetPolicy)) != null) {
                    hasFactoryMethod = beanMappingMethod.getFactoryMethod() != null;
                    mappingMethods.add(beanMappingMethod);
                }
            }
            if (hasFactoryMethod) continue;
            this.reportErrorIfNoImplementationTypeIsRegisteredForInterfaceReturnType(method);
        }
        return mappingMethods;
    }

    private MethodReference getFactoryMethod(List<MapperReference> mapperReferences, List<SourceMethod> methods, Type returnType) {
        MethodReference result = null;
        for (SourceMethod method : methods) {
            List<Type> parameterTypes;
            if (method.requiresImplementation() || method.isIterableMapping() || method.isMapMapping() || method.getSourceParameters().size() != 0 || !method.matches(parameterTypes = MethodSelectors.getParameterTypes(this.typeFactory, method.getParameters(), null, returnType), returnType)) continue;
            if (result == null) {
                MapperReference mapperReference = this.findMapperReference(mapperReferences, method);
                result = new MethodReference(method, mapperReference, null);
                continue;
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Ambiguous factory methods: \"%s\" conflicts with \"%s\".", result, method), method.getExecutable());
        }
        return result;
    }

    private void reportErrorIfNoImplementationTypeIsRegisteredForInterfaceReturnType(SourceMethod method) {
        if (method.getReturnType().getTypeMirror().getKind() != TypeKind.VOID && method.getReturnType().isInterface() && method.getReturnType().getImplementationType() == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("No implementation type is registered for return type %s.", method.getReturnType()), method.getExecutable());
        }
    }

    private Map<String, List<Mapping>> reverse(Map<String, List<Mapping>> mappings) {
        HashMap<String, List<Mapping>> reversed = new HashMap<String, List<Mapping>>();
        for (List<Mapping> mappingList : mappings.values()) {
            for (Mapping mapping : mappingList) {
                if (!reversed.containsKey(mapping.getTargetName())) {
                    reversed.put(mapping.getTargetName(), new ArrayList());
                }
                ((List)reversed.get(mapping.getTargetName())).add(mapping.reverse());
            }
        }
        return reversed;
    }

    private PropertyMapping getPropertyMapping(List<MapperReference> mapperReferences, List<SourceMethod> methods, SourceMethod method, ExecutableElement targetAcessor, Parameter parameter) {
        String targetPropertyName = Executables.getPropertyName(targetAcessor);
        Mapping mapping = method.getMappingByTargetPropertyName(targetPropertyName);
        String dateFormat = mapping != null ? mapping.getDateFormat() : null;
        String sourcePropertyName = mapping != null ? mapping.getSourcePropertyName() : targetPropertyName;
        TypeElement parameterElement = parameter.getType().getTypeElement();
        List<ExecutableElement> sourceGetters = Filters.getterMethodsIn(this.elementUtils.getAllMembers(parameterElement));
        for (ExecutableElement sourceAccessor : sourceGetters) {
            List<Mapping> sourceMappings = method.getMappings().get(sourcePropertyName);
            if (method.getMappings().containsKey(sourcePropertyName)) {
                for (Mapping sourceMapping : sourceMappings) {
                    boolean mapsToOtherTarget;
                    boolean bl = mapsToOtherTarget = !sourceMapping.getTargetName().equals(targetPropertyName);
                    if (!Executables.getPropertyName(sourceAccessor).equals(sourcePropertyName) || mapsToOtherTarget) continue;
                    return this.getPropertyMapping(mapperReferences, methods, method, parameter, sourceAccessor, targetAcessor, dateFormat);
                }
                continue;
            }
            if (!Executables.getPropertyName(sourceAccessor).equals(sourcePropertyName)) continue;
            return this.getPropertyMapping(mapperReferences, methods, method, parameter, sourceAccessor, targetAcessor, dateFormat);
        }
        return null;
    }

    private BeanMappingMethod getBeanMappingMethod(List<MapperReference> mapperReferences, List<SourceMethod> methods, SourceMethod method, ReportingPolicy unmappedTargetPolicy) {
        ArrayList<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();
        HashSet<String> mappedTargetProperties = new HashSet<String>();
        if (!this.reportErrorIfMappedPropertiesDontExist(method)) {
            return null;
        }
        TypeElement resultTypeElement = method.getResultType().getTypeElement();
        List<ExecutableElement> targetAccessors = Filters.setterMethodsIn(this.elementUtils.getAllMembers(resultTypeElement));
        targetAccessors.addAll(this.alternativeTargetAccessorMethodsIn(this.elementUtils.getAllMembers(resultTypeElement)));
        for (ExecutableElement targetAccessor : targetAccessors) {
            String targetPropertyName = Executables.getPropertyName(targetAccessor);
            Mapping mapping = method.getMappingByTargetPropertyName(targetPropertyName);
            PropertyMapping propertyMapping = null;
            if (mapping != null && mapping.getSourceParameterName() != null) {
                Parameter parameter = method.getSourceParameter(mapping.getSourceParameterName());
                propertyMapping = this.getPropertyMapping(mapperReferences, methods, method, targetAccessor, parameter);
            }
            if (propertyMapping == null) {
                for (Parameter sourceParameter : method.getSourceParameters()) {
                    PropertyMapping newPropertyMapping = this.getPropertyMapping(mapperReferences, methods, method, targetAccessor, sourceParameter);
                    if (propertyMapping != null && newPropertyMapping != null) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, "Several possible source properties for target property \"" + targetPropertyName + "\".", method.getExecutable());
                        break;
                    }
                    if (newPropertyMapping == null) continue;
                    propertyMapping = newPropertyMapping;
                }
            }
            if (propertyMapping == null) continue;
            propertyMappings.add(propertyMapping);
            mappedTargetProperties.add(targetPropertyName);
        }
        Set<String> targetProperties = Executables.getPropertyNames(targetAccessors);
        this.reportErrorForUnmappedTargetPropertiesIfRequired(method, unmappedTargetPolicy, targetProperties, mappedTargetProperties);
        MethodReference factoryMethod = this.getFactoryMethod(mapperReferences, methods, method.getReturnType());
        return new BeanMappingMethod(method, propertyMappings, factoryMethod);
    }

    private void reportErrorForUnmappedTargetPropertiesIfRequired(SourceMethod method, ReportingPolicy unmappedTargetPolicy, Set<String> targetProperties, Set<String> mappedTargetProperties) {
        if (targetProperties.size() > mappedTargetProperties.size() && unmappedTargetPolicy.requiresReport()) {
            targetProperties.removeAll(mappedTargetProperties);
            this.messager.printMessage(unmappedTargetPolicy.getDiagnosticKind(), MessageFormat.format("Unmapped target {0,choice,1#property|1<properties}: \"{1}\"", targetProperties.size(), Strings.join(targetProperties, ", ")), method.getExecutable());
        }
    }

    private SourceMethod getReverseMappingMethod(List<SourceMethod> rawMethods, SourceMethod method) {
        for (SourceMethod oneMethod : rawMethods) {
            if (!oneMethod.reverses(method)) continue;
            return oneMethod;
        }
        return null;
    }

    private boolean hasSourceProperty(SourceMethod method, String propertyName) {
        for (Parameter parameter : method.getSourceParameters()) {
            if (!this.hasSourceProperty(parameter, propertyName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSourceProperty(Parameter parameter, String propertyName) {
        TypeElement parameterTypeElement = parameter.getType().getTypeElement();
        List<ExecutableElement> getters = Filters.getterMethodsIn(this.elementUtils.getAllMembers(parameterTypeElement));
        return Executables.getPropertyNames(getters).contains(propertyName);
    }

    private boolean reportErrorIfMappedPropertiesDontExist(SourceMethod method) {
        if (method.isConfiguredByReverseMappingMethod()) {
            return true;
        }
        TypeElement resultTypeElement = method.getResultType().getTypeElement();
        List<ExecutableElement> targetAccessors = Filters.setterMethodsIn(this.elementUtils.getAllMembers(resultTypeElement));
        targetAccessors.addAll(this.alternativeTargetAccessorMethodsIn(this.elementUtils.getAllMembers(resultTypeElement)));
        Set<String> targetProperties = Executables.getPropertyNames(targetAccessors);
        boolean foundUnmappedProperty = false;
        for (List<Mapping> mappedProperties : method.getMappings().values()) {
            for (Mapping mappedProperty : mappedProperties) {
                if (mappedProperty.getSourceParameterName() != null) {
                    Parameter sourceParameter = method.getSourceParameter(mappedProperty.getSourceParameterName());
                    if (sourceParameter == null) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Method has no parameter named \"%s\".", mappedProperty.getSourceParameterName()), method.getExecutable(), mappedProperty.getMirror(), mappedProperty.getSourceAnnotationValue());
                        foundUnmappedProperty = true;
                    } else if (!this.hasSourceProperty(sourceParameter, mappedProperty.getSourcePropertyName())) {
                        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("The type of parameter \"%s\" has no property named \"%s\".", mappedProperty.getSourceParameterName(), mappedProperty.getSourcePropertyName()), method.getExecutable(), mappedProperty.getMirror(), mappedProperty.getSourceAnnotationValue());
                        foundUnmappedProperty = true;
                    }
                } else if (!this.hasSourceProperty(method, mappedProperty.getSourcePropertyName())) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("No property named \"%s\" exists in source parameter(s).", mappedProperty.getSourceName()), method.getExecutable(), mappedProperty.getMirror(), mappedProperty.getSourceAnnotationValue());
                    foundUnmappedProperty = true;
                }
                if (targetProperties.contains(mappedProperty.getTargetName())) continue;
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Unknown property \"%s\" in return type %s.", mappedProperty.getTargetName(), method.getResultType()), method.getExecutable(), mappedProperty.getMirror(), mappedProperty.getTargetAnnotationValue());
                foundUnmappedProperty = true;
            }
        }
        return !foundUnmappedProperty;
    }

    private PropertyMapping getPropertyMapping(List<MapperReference> mapperReferences, List<SourceMethod> methods, SourceMethod method, Parameter parameter, ExecutableElement sourceAccessor, ExecutableElement targetAcessor, String dateFormat) {
        Type sourceType = this.typeFactory.getReturnType(sourceAccessor);
        Type targetType = null;
        String conversionString = parameter.getName() + "." + sourceAccessor.getSimpleName().toString() + "()";
        if (Executables.isSetterMethod(targetAcessor)) {
            targetType = this.typeFactory.getSingleParameter(targetAcessor).getType();
        } else if (Executables.isGetterMethod(targetAcessor)) {
            targetType = this.typeFactory.getReturnType(targetAcessor);
        }
        String targetPropertyName = Executables.getPropertyName(targetAcessor);
        String mappedElement = "property '" + Executables.getPropertyName(sourceAccessor) + "'";
        MethodReference mappingMethodReference = this.getMappingMethodReferenceBasedOnMethod(method, mappedElement, mapperReferences, methods, sourceType, targetType, targetPropertyName, dateFormat);
        TypeConversion conversion = this.getConversion(sourceType, targetType, dateFormat, conversionString);
        PropertyMapping property = new PropertyMapping(parameter.getName(), Executables.getPropertyName(sourceAccessor), sourceAccessor.getSimpleName().toString(), sourceType, Executables.getPropertyName(targetAcessor), targetAcessor.getSimpleName().toString(), targetType, mappingMethodReference, conversion);
        if (!this.isPropertyMappable(property)) {
            mappingMethodReference = this.getMappingMethodReferenceBasedOnParameter(method, "property '" + Executables.getPropertyName(sourceAccessor) + "'", mapperReferences, methods, sourceType, targetType, targetPropertyName, dateFormat);
            property = new PropertyMapping(parameter.getName(), Executables.getPropertyName(sourceAccessor), sourceAccessor.getSimpleName().toString(), sourceType, Executables.getPropertyName(targetAcessor), targetAcessor.getSimpleName().toString(), targetType, mappingMethodReference, conversion);
        }
        if (!this.isPropertyMappable(property)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Can't map property \"%s %s\" to \"%s %s\".", property.getSourceType(), property.getSourceName(), property.getTargetType(), property.getTargetName()), method.getExecutable());
        }
        return property;
    }

    private IterableMappingMethod getIterableMappingMethod(List<MapperReference> mapperReferences, List<SourceMethod> methods, SourceMethod method) {
        Type sourceElementType = method.getSourceParameters().iterator().next().getType().getTypeParameters().get(0);
        Type targetElementType = method.getResultType().getTypeParameters().get(0);
        String dateFormat = method.getIterableMapping() != null ? method.getIterableMapping().getDateFormat() : null;
        TypeConversion conversion = this.getConversion(sourceElementType, targetElementType, dateFormat, Strings.getSaveVariableName(sourceElementType.getName(), method.getParameterNames()));
        MethodReference mappingMethodReference = this.getMappingMethodReferenceBasedOnMethod(method, "collection element", mapperReferences, methods, sourceElementType, targetElementType, null, dateFormat);
        if (!sourceElementType.isAssignableTo(targetElementType) && conversion == null && mappingMethodReference == null) {
            mappingMethodReference = this.getMappingMethodReferenceBasedOnParameter(method, "collection element", mapperReferences, methods, sourceElementType, targetElementType, null, dateFormat);
        }
        if (!sourceElementType.isAssignableTo(targetElementType) && conversion == null && mappingMethodReference == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Can't create implementation of method %s. Found no method nor built-in conversion for mapping source element type into target element type.", method), method.getExecutable());
        }
        MethodReference factoryMethod = this.getFactoryMethod(mapperReferences, methods, method.getReturnType());
        return new IterableMappingMethod(method, mappingMethodReference, conversion, factoryMethod);
    }

    private MapMappingMethod getMapMappingMethod(List<MapperReference> mapperReferences, List<SourceMethod> methods, SourceMethod method) {
        List<Type> sourceTypeParams = method.getSourceParameters().iterator().next().getType().getTypeParameters();
        List<Type> resultTypeParams = method.getResultType().getTypeParameters();
        Type keySourceType = sourceTypeParams.get(0);
        Type keyTargetType = resultTypeParams.get(0);
        String keyDateFormat = method.getMapMapping() != null ? method.getMapMapping().getKeyFormat() : null;
        MethodReference keyMappingMethod = this.getMappingMethodReferenceBasedOnMethod(method, "map key", mapperReferences, methods, keySourceType, keyTargetType, null, keyDateFormat);
        TypeConversion keyConversion = this.getConversion(keySourceType, keyTargetType, keyDateFormat, "entry.getKey()");
        if (!keySourceType.isAssignableTo(keyTargetType) && keyConversion == null && keyMappingMethod == null) {
            keyMappingMethod = this.getMappingMethodReferenceBasedOnParameter(method, "map key", mapperReferences, methods, keySourceType, keyTargetType, null, keyDateFormat);
        }
        if (!keySourceType.isAssignableTo(keyTargetType) && keyConversion == null && keyMappingMethod == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Can't create implementation of method %s. Found no method nor built-in conversion for mapping source key type to target key type.", method), method.getExecutable());
        }
        Type valueSourceType = sourceTypeParams.get(1);
        Type valueTargetType = resultTypeParams.get(1);
        String valueDateFormat = method.getMapMapping() != null ? method.getMapMapping().getValueFormat() : null;
        MethodReference valueMappingMethod = this.getMappingMethodReferenceBasedOnMethod(method, "map value", mapperReferences, methods, valueSourceType, valueTargetType, null, valueDateFormat);
        TypeConversion valueConversion = this.getConversion(valueSourceType, valueTargetType, valueDateFormat, "entry.getValue()");
        if (!valueSourceType.isAssignableTo(valueTargetType) && valueConversion == null && valueMappingMethod == null) {
            keyMappingMethod = this.getMappingMethodReferenceBasedOnParameter(method, "map value", mapperReferences, methods, valueSourceType, valueTargetType, null, valueDateFormat);
        }
        if (!valueSourceType.isAssignableTo(valueTargetType) && valueConversion == null && valueMappingMethod == null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Can't create implementation of method %s. Found no method nor built-in conversion for mapping source value type to target value type.", method), method.getExecutable());
        }
        MethodReference factoryMethod = this.getFactoryMethod(mapperReferences, methods, method.getReturnType());
        return new MapMappingMethod(method, keyMappingMethod, keyConversion, valueMappingMethod, valueConversion, factoryMethod);
    }

    private EnumMappingMethod getEnumMappingMethod(SourceMethod method) {
        if (!this.reportErrorIfMappedEnumConstantsDontExist(method) || !this.reportErrorIfSourceEnumConstantsWithoutCorrespondingTargetConstantAreNotMapped(method)) {
            return null;
        }
        ArrayList<EnumMapping> enumMappings = new ArrayList<EnumMapping>();
        List<String> sourceEnumConstants = method.getSourceParameters().iterator().next().getType().getEnumConstants();
        Map<String, List<Mapping>> mappings = method.getMappings();
        for (String enumConstant : sourceEnumConstants) {
            List<Mapping> mappedConstants = mappings.get(enumConstant);
            if (mappedConstants == null) {
                enumMappings.add(new EnumMapping(enumConstant, enumConstant));
                continue;
            }
            if (mappedConstants.size() == 1) {
                enumMappings.add(new EnumMapping(enumConstant, mappedConstants.iterator().next().getTargetName()));
                continue;
            }
            ArrayList<String> targetConstants = new ArrayList<String>(mappedConstants.size());
            for (Mapping mapping : mappedConstants) {
                targetConstants.add(mapping.getTargetName());
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("One enum constant must not be mapped to more than one target constant, but constant %s is mapped to %s.", enumConstant, Strings.join(targetConstants, ", ")), method.getExecutable());
        }
        return new EnumMappingMethod(method, enumMappings);
    }

    private boolean reportErrorIfMappedEnumConstantsDontExist(SourceMethod method) {
        if (method.isConfiguredByReverseMappingMethod()) {
            return true;
        }
        List<String> sourceEnumConstants = method.getSourceParameters().iterator().next().getType().getEnumConstants();
        List<String> targetEnumConstants = method.getReturnType().getEnumConstants();
        boolean foundIncorrectMapping = false;
        for (List<Mapping> mappedConstants : method.getMappings().values()) {
            for (Mapping mappedConstant : mappedConstants) {
                if (mappedConstant.getSourceName() == null) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "A source constant must be specified for mappings of an enum mapping method.", method.getExecutable(), mappedConstant.getMirror());
                    foundIncorrectMapping = true;
                } else if (!sourceEnumConstants.contains(mappedConstant.getSourceName())) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Constant %s doesn't exist in enum type %s.", mappedConstant.getSourceName(), method.getSourceParameters().iterator().next().getType()), method.getExecutable(), mappedConstant.getMirror(), mappedConstant.getSourceAnnotationValue());
                    foundIncorrectMapping = true;
                }
                if (mappedConstant.getTargetName() == null) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "A target constant must be specified for mappings of an enum mapping method.", method.getExecutable(), mappedConstant.getMirror());
                    foundIncorrectMapping = true;
                    continue;
                }
                if (targetEnumConstants.contains(mappedConstant.getTargetName())) continue;
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Constant %s doesn't exist in enum type %s.", mappedConstant.getTargetName(), method.getReturnType()), method.getExecutable(), mappedConstant.getMirror(), mappedConstant.getTargetAnnotationValue());
                foundIncorrectMapping = true;
            }
        }
        return !foundIncorrectMapping;
    }

    private boolean reportErrorIfSourceEnumConstantsWithoutCorrespondingTargetConstantAreNotMapped(SourceMethod method) {
        List<String> sourceEnumConstants = method.getSourceParameters().iterator().next().getType().getEnumConstants();
        List<String> targetEnumConstants = method.getReturnType().getEnumConstants();
        Set<String> mappedSourceEnumConstants = method.getMappings().keySet();
        ArrayList<String> unmappedSourceEnumConstants = new ArrayList<String>();
        for (String sourceEnumConstant : sourceEnumConstants) {
            if (targetEnumConstants.contains(sourceEnumConstant) || mappedSourceEnumConstants.contains(sourceEnumConstant)) continue;
            unmappedSourceEnumConstants.add(sourceEnumConstant);
        }
        if (!unmappedSourceEnumConstants.isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("The following constants from the source enum have no corresponding constant in the target enum and must be be mapped via @Mapping: %s", Strings.join(unmappedSourceEnumConstants, ", ")), method.getExecutable());
        }
        return unmappedSourceEnumConstants.isEmpty();
    }

    private TypeConversion getConversion(Type sourceType, Type targetType, String dateFormat, String sourceReference) {
        ConversionProvider conversionProvider = this.conversions.getConversion(sourceType, targetType);
        if (conversionProvider == null) {
            return null;
        }
        return conversionProvider.to(sourceReference, new DefaultConversionContext(this.typeFactory, targetType, dateFormat));
    }

    private MethodReference getMappingMethodReferenceBasedOnMethod(SourceMethod method, String mappedElement, List<MapperReference> mapperReferences, List<SourceMethod> methods, Type sourceType, Type targetType, String targetPropertyName, String dateFormat) {
        SourceMethod matchingSourceMethod = this.getBestMatch(method, mappedElement, methods, sourceType, targetType, targetPropertyName);
        if (matchingSourceMethod != null) {
            return this.getMappingMethodReference(matchingSourceMethod, mapperReferences, targetType);
        }
        BuiltInMethod matchingBuiltInMethod = this.getBestMatch(method, mappedElement, this.builtInMethods.getBuiltInMethods(), sourceType, targetType, targetPropertyName);
        return matchingBuiltInMethod != null ? this.getMappingMethodReference(matchingBuiltInMethod, targetType, dateFormat) : null;
    }

    private MethodReference getMappingMethodReferenceBasedOnParameter(SourceMethod mappingMethod, String mappedElement, List<MapperReference> mapperReferences, List<SourceMethod> methods, Type parameterType, Type returnType, String targetPropertyName, String dateFormat) {
        ArrayList<SourceMethod> methodYCandidates = new ArrayList<SourceMethod>(methods);
        methodYCandidates.addAll(this.builtInMethods.getBuiltInMethods());
        MethodReference methodRefY = null;
        for (Method method : methodYCandidates) {
            if (method.getSourceParameters().size() != 1 || (methodRefY = this.getMappingMethodReferenceBasedOnMethod(mappingMethod, mappedElement, mapperReferences, methods, method.getSourceParameters().get(0).getType(), returnType, targetPropertyName, dateFormat)) == null) continue;
            MethodReference methodRefX = this.getMappingMethodReferenceBasedOnMethod(mappingMethod, mappedElement, mapperReferences, methods, parameterType, method.getSourceParameters().get(0).getType(), targetPropertyName, dateFormat);
            if (methodRefX != null) {
                methodRefY.setMethodRefChild(methodRefX);
                break;
            }
            methodRefY = null;
        }
        return methodRefY;
    }

    private <T extends Method> T getBestMatch(SourceMethod mappingMethod, String mappedElement, List<T> methods, Type sourceType, Type returnType, String targetPropertyName) {
        List<T> candidates = this.methodSelectors.getMatchingMethods(mappingMethod, methods, sourceType, returnType, targetPropertyName);
        if (candidates.size() > 1) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Ambiguous mapping methods found for mapping " + mappedElement + " from %s to %s: %s.", sourceType, returnType, Strings.join(candidates, ", ")), mappingMethod.getExecutable());
        }
        if (!candidates.isEmpty()) {
            return (T)((Method)candidates.get(0));
        }
        return null;
    }

    private MethodReference getMappingMethodReference(SourceMethod method, List<MapperReference> mapperReferences, Type targetType) {
        MapperReference mapperReference = this.findMapperReference(mapperReferences, method);
        return new MethodReference(method, mapperReference, SourceMethod.containsTargetTypeParameter(method.getParameters()) ? targetType : null);
    }

    private MapperReference findMapperReference(List<MapperReference> mapperReferences, SourceMethod method) {
        for (MapperReference ref : mapperReferences) {
            if (!ref.getType().equals(method.getDeclaringMapper())) continue;
            return ref;
        }
        return null;
    }

    private MethodReference getMappingMethodReference(BuiltInMethod method, Type returnType, String dateFormat) {
        this.virtualMethods.add(new VirtualMappingMethod(method));
        DefaultConversionContext ctx = new DefaultConversionContext(this.typeFactory, returnType, dateFormat);
        return new MethodReference(method, ctx);
    }

    private boolean isPropertyMappable(PropertyMapping property) {
        boolean collectionOrMapTargetTypeHasCompatibleConstructor = false;
        if (property.getSourceType().isCollectionType() && property.getTargetType().isCollectionType()) {
            collectionOrMapTargetTypeHasCompatibleConstructor = this.collectionTypeHasCompatibleConstructor(property.getSourceType(), property.getTargetType().getImplementationType() != null ? property.getTargetType().getImplementationType() : property.getTargetType());
        }
        if (property.getSourceType().isMapType() && property.getTargetType().isMapType()) {
            collectionOrMapTargetTypeHasCompatibleConstructor = this.mapTypeHasCompatibleConstructor(property.getSourceType(), property.getTargetType().getImplementationType() != null ? property.getTargetType().getImplementationType() : property.getTargetType());
        }
        return property.getSourceType().isAssignableTo(property.getTargetType()) || property.getMappingMethod() != null || property.getConversion() != null || (property.getTargetType().isCollectionType() || property.getTargetType().isMapType()) && collectionOrMapTargetTypeHasCompatibleConstructor;
    }

    private boolean collectionTypeHasCompatibleConstructor(Type sourceType, Type targetType) {
        TypeMirror sourceElementType = sourceType.getTypeParameters().isEmpty() ? this.typeFactory.getType(Object.class).getTypeMirror() : sourceType.getTypeParameters().get(0).getTypeMirror();
        TypeMirror targetElementType = targetType.getTypeParameters().isEmpty() ? this.typeFactory.getType(Object.class).getTypeMirror() : targetType.getTypeParameters().get(0).getTypeMirror();
        return this.typeUtils.isAssignable(sourceElementType, targetElementType);
    }

    private boolean mapTypeHasCompatibleConstructor(Type sourceType, Type targetType) {
        TypeMirror sourceKeyType = null;
        TypeMirror targetKeyType = null;
        TypeMirror sourceValueType = null;
        TypeMirror targetValueType = null;
        if (sourceType.getTypeParameters().isEmpty()) {
            sourceKeyType = this.typeFactory.getType(Object.class).getTypeMirror();
            sourceValueType = this.typeFactory.getType(Object.class).getTypeMirror();
        } else {
            sourceKeyType = sourceType.getTypeParameters().get(0).getTypeMirror();
            sourceValueType = sourceType.getTypeParameters().get(1).getTypeMirror();
        }
        if (targetType.getTypeParameters().isEmpty()) {
            targetKeyType = this.typeFactory.getType(Object.class).getTypeMirror();
            targetValueType = this.typeFactory.getType(Object.class).getTypeMirror();
        } else {
            targetKeyType = targetType.getTypeParameters().get(0).getTypeMirror();
            targetValueType = targetType.getTypeParameters().get(1).getTypeMirror();
        }
        return this.typeUtils.isAssignable(sourceKeyType, targetKeyType) && this.typeUtils.isAssignable(sourceValueType, targetValueType);
    }

    private List<ExecutableElement> alternativeTargetAccessorMethodsIn(Iterable<? extends Element> elements) {
        List<ExecutableElement> setterMethods = Filters.setterMethodsIn(elements);
        List<ExecutableElement> getterMethods = Filters.getterMethodsIn(elements);
        LinkedList<ExecutableElement> alternativeTargetAccessorsMethods = new LinkedList<ExecutableElement>();
        if (getterMethods.size() > setterMethods.size()) {
            for (ExecutableElement getterMethod : getterMethods) {
                boolean matchFound = false;
                String getterPropertyName = Executables.getPropertyName(getterMethod);
                for (ExecutableElement setterMethod : setterMethods) {
                    String setterPropertyName = Executables.getPropertyName(setterMethod);
                    if (!getterPropertyName.equals(setterPropertyName)) continue;
                    matchFound = true;
                    break;
                }
                if (matchFound || !this.typeFactory.getReturnType(getterMethod).isCollectionType()) continue;
                alternativeTargetAccessorsMethods.add(getterMethod);
            }
        }
        return alternativeTargetAccessorsMethods;
    }
}

