/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.util;

import java.beans.Introspector;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;

public class Executables {
    private Executables() {
    }

    public static boolean isGetterMethod(ExecutableElement method) {
        return Executables.isPublic(method) && (Executables.isNonBooleanGetterMethod(method) || Executables.isBooleanGetterMethod(method));
    }

    private static boolean isNonBooleanGetterMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return method.getParameters().isEmpty() && name.startsWith("get") && name.length() > 3 && method.getReturnType().getKind() != TypeKind.VOID;
    }

    private static boolean isBooleanGetterMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return method.getParameters().isEmpty() && name.startsWith("is") && name.length() > 2 && method.getReturnType().getKind() == TypeKind.BOOLEAN;
    }

    public static boolean isSetterMethod(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        return Executables.isPublic(method) && name.startsWith("set") && name.length() > 3 && method.getParameters().size() == 1 && method.getReturnType().getKind() == TypeKind.VOID;
    }

    private static boolean isPublic(ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public static String getPropertyName(ExecutableElement getterOrSetterMethod) {
        if (Executables.isNonBooleanGetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(getterOrSetterMethod.getSimpleName().toString().substring(3));
        }
        if (Executables.isBooleanGetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(getterOrSetterMethod.getSimpleName().toString().substring(2));
        }
        if (Executables.isSetterMethod(getterOrSetterMethod)) {
            return Introspector.decapitalize(getterOrSetterMethod.getSimpleName().toString().substring(3));
        }
        throw new IllegalArgumentException("Executable " + getterOrSetterMethod + " is not getter or setter method.");
    }

    public static Set<String> getPropertyNames(List<ExecutableElement> propertyAccessors) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (ExecutableElement executableElement : propertyAccessors) {
            propertyNames.add(Executables.getPropertyName(executableElement));
        }
        return propertyNames;
    }
}

