/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import org.mapstruct.ap.internal.conversion.SimpleConversion;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.util.NativeTypes;
import org.mapstruct.ap.internal.util.Strings;

public class WrapperToStringConversion
extends SimpleConversion {
    private final Class<?> sourceType;
    private final Class<?> primitiveType;

    public WrapperToStringConversion(Class<?> sourceType) {
        if (sourceType.isPrimitive()) {
            throw new IllegalArgumentException(sourceType + " is no wrapper type.");
        }
        this.sourceType = sourceType;
        this.primitiveType = NativeTypes.getPrimitiveType(sourceType);
    }

    @Override
    public String getToExpression(ConversionContext conversionContext) {
        return "String.valueOf( <SOURCE> )";
    }

    @Override
    public String getFromExpression(ConversionContext conversionContext) {
        return this.sourceType.getSimpleName() + ".parse" + Strings.capitalize(this.primitiveType.getSimpleName()) + "( <SOURCE> )";
    }
}

